/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Result;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Problem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaToolResultDatabase;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.DuplicateCodeConsumerKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.DuplicatesProblem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.GlobalOutputConsumer;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;
import org.jetbrains.qodana.staticAnalysis.sarif.ContextRegionKt;
import org.jetbrains.qodana.staticAnalysis.sarif.ElementToSarifConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\nH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JN\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u001e\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\nH\u0016J'\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicateCodeConsumer;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/GlobalOutputConsumer;", "()V", "inspectionName", "", "consumeDuplicatedCodeAggregateXml", "", "root", "Lorg/jdom/Element;", "consumer", "Lkotlin/Function2;", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/Problem;", "consumeDuplicatedCodeXml", "database", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "consumeOwnedFiles", "profileState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "paths", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "findOffset", "", "file", "descriptor", "Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;", "(Lcom/intellij/openapi/components/PathMacroManager;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;)Ljava/lang/Integer;", "ownedFiles", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nDuplicateCodeConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateCodeConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicateCodeConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n661#2,11:139\n661#2,11:150\n1549#2:161\n1620#2,3:162\n*S KotlinDebug\n*F\n+ 1 DuplicateCodeConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/globalOutput/DuplicateCodeConsumer\n*L\n49#1:139,11\n50#1:150,11\n75#1:161\n75#1:162,3\n*E\n"})
public final class DuplicateCodeConsumer
implements GlobalOutputConsumer {
    @NotNull
    private final String inspectionName;

    public DuplicateCodeConsumer() {
        this.inspectionName = "DuplicatedCode";
    }

    @Override
    public void consumeOwnedFiles(@NotNull QodanaProfile.QodanaProfileState profileState, @NotNull List<? extends Path> paths, @NotNull QodanaToolResultDatabase database, @NotNull Project project2, @NotNull Function2<? super List<? extends Problem>, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)profileState, (String)"profileState");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)project2));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(project)");
        PathMacroManager macroManager = pathMacroManager;
        if (!GlobalOutputConsumer.Companion.reportingInspectionAllowed(profileState, this.inspectionName) || paths.size() != 2) {
            return;
        }
        GlobalOutputConsumer.Companion.consumeOutputXmlFile((Path)CollectionsKt.first(paths), (Function2<? super String, ? super Element, Unit>)((Function2)new Function2<String, Element, Unit>(this, database, macroManager){
            final /* synthetic */ DuplicateCodeConsumer this$0;
            final /* synthetic */ QodanaToolResultDatabase $database;
            final /* synthetic */ PathMacroManager $macroManager;
            {
                this.this$0 = $receiver;
                this.$database = $database;
                this.$macroManager = $macroManager;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull Element root2) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                DuplicateCodeConsumer.access$consumeDuplicatedCodeXml(this.this$0, root2, this.$database, this.$macroManager);
            }
        }));
        GlobalOutputConsumer.Companion.consumeOutputXmlFile((Path)CollectionsKt.last(paths), (Function2<? super String, ? super Element, Unit>)((Function2)new Function2<String, Element, Unit>(this, consumer){
            final /* synthetic */ DuplicateCodeConsumer this$0;
            final /* synthetic */ Function2<List<? extends Problem>, String, Unit> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull Element root2) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                DuplicateCodeConsumer.access$consumeDuplicatedCodeAggregateXml(this.this$0, root2, this.$consumer);
            }
        }));
    }

    @Override
    @NotNull
    public List<Path> ownedFiles(@NotNull List<? extends Path> paths) {
        Object v1;
        Path duplicatedCode;
        block5: {
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Iterable $this$singleOrNull$iv = paths;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((File)it.toFile()), (Object)"DuplicatedCode")) continue;
                    if (found$iv) {
                        v0 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            duplicatedCode = v0;
            Iterable $this$singleOrNull$iv = paths;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((File)it.toFile()), (Object)"DuplicatedCode_aggregate")) continue;
                if (found$iv) {
                    v1 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Path duplicatedCodeAggregate = v1;
        Object[] objectArray = new Path[]{duplicatedCode, duplicatedCodeAggregate};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final void consumeDuplicatedCodeXml(Element root2, QodanaToolResultDatabase database, PathMacroManager macroManager) {
        Message message = new Message().withText("Duplicated code").withMarkdown("Duplicated code");
        for (Element problem : root2.getChildren("problem")) {
            try {
                macroManager.collapsePathsRecursively(problem);
                Intrinsics.checkNotNullExpressionValue((Object)problem, (String)"problem");
                Result sarif = ElementToSarifConverter.INSTANCE.convertFromXmlFormat$intellij_qodana(problem, macroManager, 0, message);
                CommonDescriptor problemLocation = ElementToSarifConverter.INSTANCE.commonDescriptor(problem);
                String string = problemLocation.getFile();
                Integer n = problemLocation.getLine();
                int n2 = n != null ? n : 0;
                Integer n3 = this.findOffset(macroManager, problemLocation.getFile(), problemLocation);
                int n4 = n3 != null ? n3 : 0;
                String string2 = sarif.getPartialFingerprints().getLastValue("equalIndicator");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sarif.partialFingerprint\u2026culation.EQUAL_INDICATOR)");
                String string3 = DuplicateCodeConsumerKt.access$getGson$p().toJson((Object)sarif, (Type)((Object)Result.class));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"gson.toJson(sarif, Result::class.java)");
                database.insertDuplicate(string, n2, n4, 0, string2, string3);
            }
            catch (Exception e) {
                DuplicateCodeConsumerKt.access$getLOG$p().warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeDuplicatedCodeAggregateXml(Element root2, Function2<? super List<? extends Problem>, ? super String, Unit> consumer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2 = root2.getChildren("duplicate");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"root.getChildren(\"duplicate\")");
        Iterable iterable = list2;
        Function2<? super List<? extends Problem>, ? super String, Unit> function2 = consumer;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new DuplicatesProblem((Element)it));
        }
        function2.invoke((Object)((List)destination$iv$iv), (Object)"DuplicatedCode");
    }

    private final Integer findOffset(PathMacroManager macroManager, String file, CommonDescriptor descriptor) {
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(macroManager.expandPath(file));
        if (virtualFile2 == null || virtualFile2.isDirectory()) {
            return null;
        }
        String string = VfsUtil.loadText((VirtualFile)virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(virtualFile)");
        String text2 = string;
        return ContextRegionKt.getProblemOffset(text2, descriptor);
    }

    public static final /* synthetic */ void access$consumeDuplicatedCodeXml(DuplicateCodeConsumer $this, Element root2, QodanaToolResultDatabase database, PathMacroManager macroManager) {
        $this.consumeDuplicatedCodeXml(root2, database, macroManager);
    }

    public static final /* synthetic */ void access$consumeDuplicatedCodeAggregateXml(DuplicateCodeConsumer $this, Element root2, Function2 consumer) {
        $this.consumeDuplicatedCodeAggregateXml(root2, (Function2<? super List<? extends Problem>, ? super String, Unit>)consumer);
    }
}

