/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.components.PathMacroManager;
import com.jetbrains.qodana.sarif.model.Level;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LogicalLocation;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.VersionedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;
import org.jetbrains.qodana.staticAnalysis.sarif.textFormat.Text_formatKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J3\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001dJ\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001f\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/ElementToSarifConverter;", "", "()V", "DESCRIPTION", "", "FILE", "FRAMEWORK", "HIGHLIGHTED_ELEMENT", "INSPECTION_RESULTS_LANGUAGE", "LENGTH", "LINE", "MODULE", "OFFSET", "SEVERITY_ATTR", "commonDescriptor", "Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;", "problem", "Lorg/jdom/Element;", "computeHash", "Lcom/jetbrains/qodana/sarif/model/Result;", "result", "convertCommonXmlPart", "providedMessage", "Lcom/jetbrains/qodana/sarif/model/Message;", "convertFromXmlFormat", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "linesMargin", "", "convertFromXmlFormat$intellij_qodana", "getLogicalLocation", "", "Lcom/jetbrains/qodana/sarif/model/LogicalLocation;", "tryGetInt", "elementName", "(Lorg/jdom/Element;Ljava/lang/String;)Ljava/lang/Integer;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nElementToSarifConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementToSarifConverter.kt\norg/jetbrains/qodana/staticAnalysis/sarif/ElementToSarifConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class ElementToSarifConverter {
    @NotNull
    public static final ElementToSarifConverter INSTANCE = new ElementToSarifConverter();
    @NotNull
    public static final String FILE = "file";
    @NotNull
    public static final String LINE = "line";
    @NotNull
    private static final String OFFSET = "offset";
    @NotNull
    private static final String LENGTH = "length";
    @NotNull
    private static final String INSPECTION_RESULTS_LANGUAGE = "language";
    @NotNull
    private static final String FRAMEWORK = "framework";
    @NotNull
    private static final String MODULE = "module";
    @NotNull
    private static final String SEVERITY_ATTR = "severity";
    @NotNull
    private static final String DESCRIPTION = "description";
    @NotNull
    private static final String HIGHLIGHTED_ELEMENT = "highlighted_element";

    private ElementToSarifConverter() {
    }

    @NotNull
    public final Result convertFromXmlFormat$intellij_qodana(@NotNull Element problem, @NotNull PathMacroManager macroManager, int linesMargin, @Nullable Message providedMessage) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
        CommonDescriptor problemLocation = this.commonDescriptor(problem);
        Result result = this.convertCommonXmlPart(problem, providedMessage);
        Location loc = new Location();
        if (!StringsKt.isBlank((CharSequence)problemLocation.getFile())) {
            loc.setPhysicalLocation(SarifKt.getPhysicalLocation(problemLocation, macroManager, linesMargin));
        }
        Set<LogicalLocation> set = this.getLogicalLocation(problem);
        if (set != null) {
            Set<LogicalLocation> set2;
            Set<LogicalLocation> it = set2 = set;
            boolean bl = false;
            loc.setLogicalLocations(it);
        }
        Result result2 = result.withLocations(CollectionsKt.listOf((Object)loc));
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result\n      .withLocations(listOf(loc))");
        result = result2;
        return this.computeHash(result);
    }

    public static /* synthetic */ Result convertFromXmlFormat$intellij_qodana$default(ElementToSarifConverter elementToSarifConverter, Element element2, PathMacroManager pathMacroManager, int n, Message message, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            message = null;
        }
        return elementToSarifConverter.convertFromXmlFormat$intellij_qodana(element2, pathMacroManager, n, message);
    }

    @NotNull
    public final CommonDescriptor commonDescriptor(@NotNull Element problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        String string = problem.getChildText(FILE);
        if (string == null) {
            string = "";
        }
        return new CommonDescriptor(string, this.tryGetInt(problem, LINE), this.tryGetInt(problem, OFFSET), this.tryGetInt(problem, LENGTH), problem.getChildText(HIGHLIGHTED_ELEMENT), problem.getChildText(INSPECTION_RESULTS_LANGUAGE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result convertCommonXmlPart(@NotNull Element problem, @Nullable Message providedMessage) {
        void it;
        PropertyBag propertyBag;
        Object object;
        String string;
        Object[] it2;
        Element problemClass;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Element element2 = problemClass = problem.getChild("problem_class");
        String severity = element2 != null ? element2.getAttributeValue(SEVERITY_ATTR) : null;
        String inspectionId = problemClass.getAttributeValue("id");
        Object object2 = HighlightDisplayLevel.find((String)severity);
        if (object2 == null || (object2 = object2.getSeverity()) == null || (object2 = SarifKt.toLevel((HighlightSeverity)object2)) == null) {
            object2 = Level.NOTE;
        }
        Object level = object2;
        Object[] objectArray = problem.getChildText(DESCRIPTION);
        if (objectArray != null) {
            it2 = objectArray;
            boolean bl = false;
            string = ProblemDescriptorUtil.removeLocReference((String)it2);
        } else {
            string = null;
        }
        String description2 = string;
        List tags = new ArrayList();
        it2 = new String[2];
        it2[0] = problem.getChildText(INSPECTION_RESULTS_LANGUAGE);
        Element element3 = problem.getChild(FRAMEWORK);
        it2[1] = element3 != null ? element3.getText() : null;
        for (String element4 : SequencesKt.sequenceOf((Object[])it2)) {
            CharSequence bl = element4;
            if (bl == null || bl.length() == 0) continue;
            tags.add(element4);
        }
        Message message = providedMessage;
        if (message == null) {
            String string2;
            String string3;
            Message message2 = new Message();
            String string4 = description2;
            if (string4 != null) {
                String bl = string4;
                object = message2;
                boolean bl2 = false;
                string3 = Text_formatKt.htmlToPlainText(description2);
                message2 = object;
            } else {
                string3 = null;
            }
            Object object3 = message2.withText(string3);
            String string5 = description2;
            if (string5 != null) {
                String it3 = string5;
                object = object3;
                boolean bl = false;
                string2 = Text_formatKt.htmlToMarkdown(it3);
                object3 = object;
            } else {
                string2 = null;
            }
            message = ((Message)object3).withMarkdown(string2);
        }
        Message message3 = message;
        PropertyBag bl = propertyBag = SarifKt.withIdeaAndQodanaSeverities(new PropertyBag(), severity, (Level)((Object)level));
        object = new Result(message3).withRuleId(inspectionId).withLevel((Level)((Object)level));
        boolean bl3 = false;
        it.getTags().addAll(tags);
        Result result = ((Result)object).withProperties(propertyBag);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"Result(message)\n      .w\u2026ags.addAll(tags)\n      })");
        return result;
    }

    public static /* synthetic */ Result convertCommonXmlPart$default(ElementToSarifConverter elementToSarifConverter, Element element2, Message message, int n, Object object) {
        if ((n & 2) != 0) {
            message = null;
        }
        return elementToSarifConverter.convertCommonXmlPart(element2, message);
    }

    @NotNull
    public final Result computeHash(@NotNull Result result) {
        VersionedMap<String> versionedMap;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        VersionedMap<String> $this$computeHash_u24lambda_u245 = versionedMap = new VersionedMap<String>();
        boolean bl = false;
        $this$computeHash_u24lambda_u245.put("equalIndicator", 1, SarifKt.calcHash(result));
        VersionedMap<String> hashes = versionedMap;
        Result result2 = result.withPartialFingerprints(hashes);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result.withPartialFingerprints(hashes)");
        return result2;
    }

    private final Set<LogicalLocation> getLogicalLocation(Element problem) {
        String module2 = problem.getChildText(MODULE);
        if (module2 != null) {
            return SetsKt.setOf((Object)new LogicalLocation().withFullyQualifiedName(module2).withKind(MODULE));
        }
        return null;
    }

    private final Integer tryGetInt(Element problem, String elementName) {
        String string = problem.getChildText(elementName);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }
}

