/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.PathKt;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.ArtifactChange;
import com.jetbrains.qodana.sarif.model.ArtifactContent;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Edge;
import com.jetbrains.qodana.sarif.model.Fix;
import com.jetbrains.qodana.sarif.model.Graph;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.Level;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LocationRelationship;
import com.jetbrains.qodana.sarif.model.LogicalLocation;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.MultiformatMessageString;
import com.jetbrains.qodana.sarif.model.Node;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Replacement;
import com.jetbrains.qodana.sarif.model.ReportingConfiguration;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorReference;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorRelationship;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.RunAutomationDetails;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.ToolComponentReference;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionApplication;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaRunner;
import org.jetbrains.qodana.staticAnalysis.sarif.Border;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;
import org.jetbrains.qodana.staticAnalysis.sarif.ContextRegionKt;
import org.jetbrains.qodana.staticAnalysis.sarif.FixesKt;
import org.jetbrains.qodana.staticAnalysis.sarif.InspectionsTaxonomy;
import org.jetbrains.qodana.staticAnalysis.sarif.QodanaSeverity;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifReportContributor;
import org.jetbrains.qodana.staticAnalysis.sarif.textFormat.Text_formatKt;
import org.jetbrains.qodana.staticAnalysis.stat.UsageCollector;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00fa\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a$\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0003\u001a&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003\u001a\b\u0010'\u001a\u00020(H\u0002\u001a\b\u0010)\u001a\u00020*H\u0000\u001a\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0003\u001a\u0016\u00101\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00103\u001a\u000204\u001a\u0014\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002020\u001d\u001a\u0016\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0003\u001a\u0010\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010;\u001a\u00020\u0003\u001a \u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0007H\u0000\u001a\u001a\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010>\u001a\u00020?2\u0006\u0010E\u001a\u00020\u0003H\u0000\u001a)\u0010F\u001a\u0004\u0018\u00010D2\u0006\u0010>\u001a\u00020?2\u0006\u0010E\u001a\u00020\u00032\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010H\u001a\u0012\u0010I\u001a\u0004\u0018\u00010\u00032\b\u0010J\u001a\u0004\u0018\u00010K\u001a!\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u000206H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010Q\u001a\f\u0010R\u001a\u00020\u0003*\u00020\fH\u0000\u001a\u0018\u0010S\u001a\b\u0012\u0004\u0012\u00020(0!*\u00020T2\u0006\u0010U\u001a\u00020(\u001a\u0012\u0010V\u001a\u00020M*\u00020W2\u0006\u0010X\u001a\u00020Y\u001a\u0012\u0010V\u001a\u00020M*\u00020Z2\u0006\u0010X\u001a\u00020Y\u001a\u0012\u0010V\u001a\u00020M*\u00020D2\u0006\u0010X\u001a\u00020Y\u001a\f\u0010[\u001a\u00020\\*\u00020]H\u0000\u001a\f\u0010^\u001a\u00020]*\u00020\\H\u0000\u001a\u001e\u0010_\u001a\u00020`*\u00020`2\b\u0010a\u001a\u0004\u0018\u00010\u00032\u0006\u0010b\u001a\u00020\\H\u0000\u001a\u0016\u0010c\u001a\u00020`*\u00020`2\b\u0010d\u001a\u0004\u0018\u00010\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PROJECT_DIR_PREFIX", "", "QODANA_JOB_URL", "QODANA_SEVERITY_KEY", "REGION_LINES_COUNT_IF_PROBLEM_IS_FILE", "", "SRCROOT_URI_BASE", "SUPPRESS_TOOL_ID_PARAMETER", "qodanaSeverity", "Lorg/jetbrains/qodana/staticAnalysis/sarif/QodanaSeverity;", "Lcom/jetbrains/qodana/sarif/model/Result;", "getQodanaSeverity", "(Lcom/jetbrains/qodana/sarif/model/Result;)Lorg/jetbrains/qodana/staticAnalysis/sarif/QodanaSeverity;", "buildReportId", "project", "Lcom/intellij/openapi/project/Project;", "chooseFix", "Lcom/jetbrains/qodana/sarif/model/Fix;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "location", "Lcom/jetbrains/qodana/sarif/model/ArtifactLocation;", "file", "Lcom/intellij/psi/PsiFile;", "constructArtifactChange", "Lcom/jetbrains/qodana/sarif/model/ArtifactChange;", "fragments", "", "Lcom/intellij/diff/fragments/LineFragment;", "text2", "constructFixes", "", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "constructReplacement", "Lcom/jetbrains/qodana/sarif/model/Replacement;", "fragment", "createDriver", "Lcom/jetbrains/qodana/sarif/model/ToolComponent;", "createGson", "Lcom/google/gson/Gson;", "createRule", "Lcom/jetbrains/qodana/sarif/model/ReportingDescriptor;", "tools", "Lcom/intellij/codeInspection/ex/ToolsImpl;", "taxonomyIndex", "taxonomyId", "createRun", "Lcom/jetbrains/qodana/sarif/model/Run;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplication$LoadedProfile;", "createSarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "runs", "createTaxonomyReference", "Lcom/jetbrains/qodana/sarif/model/ReportingDescriptorRelationship;", "getArtifactLocation", "fileUrl", "getPhysicalLocation", "Lcom/jetbrains/qodana/sarif/model/PhysicalLocation;", "problem", "Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "linesMargin", "getRegion", "Lcom/jetbrains/qodana/sarif/model/Region;", "text", "getRegionByOffset", "offset", "(Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;Ljava/lang/String;Ljava/lang/Integer;)Lcom/jetbrains/qodana/sarif/model/Region;", "loadTextFromVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "writeReport", "", "path", "Ljava/nio/file/Path;", "report", "(Ljava/nio/file/Path;Lcom/jetbrains/qodana/sarif/model/SarifReport;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calcHash", "createComponents", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaRunner;", "driver", "hash", "Lcom/jetbrains/qodana/sarif/model/Graph;", "hasher", "Lcom/google/common/hash/Hasher;", "Lcom/jetbrains/qodana/sarif/model/Location;", "toLevel", "Lcom/jetbrains/qodana/sarif/model/Level;", "Lcom/intellij/lang/annotation/HighlightSeverity;", "toSeverity", "withIdeaAndQodanaSeverities", "Lcom/jetbrains/qodana/sarif/model/PropertyBag;", "ideaSeverity", "sarifLevel", "withSuppressToolId", "suppressToolId", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nsarif.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sarif.kt\norg/jetbrains/qodana/staticAnalysis/sarif/SarifKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,382:1\n1#2:383\n1#2:418\n1855#3,2:384\n1747#3,3:386\n1855#3,2:391\n1855#3,2:393\n1855#3,2:395\n1855#3:397\n1855#3,2:398\n1856#3:400\n1855#3:401\n1045#3:402\n1855#3,2:403\n1856#3:405\n1855#3,2:406\n1603#3,9:408\n1855#3:417\n1856#3:419\n1612#3:420\n1549#3:421\n1620#3,3:422\n1282#4,2:389\n10#5:425\n*S KotlinDebug\n*F\n+ 1 sarif.kt\norg/jetbrains/qodana/staticAnalysis/sarif/SarifKt\n*L\n338#1:418\n113#1:384,2\n148#1:386,3\n221#1:391,2\n223#1:393,2\n238#1:395,2\n244#1:397\n245#1:398,2\n244#1:400\n260#1:401\n263#1:402\n263#1:403,2\n260#1:405\n269#1:406,2\n338#1:408,9\n338#1:417\n338#1:419\n338#1:420\n355#1:421\n355#1:422,3\n183#1:389,2\n46#1:425\n*E\n"})
public final class SarifKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String PROJECT_DIR_PREFIX = "file://$PROJECT_DIR$/";
    @NotNull
    private static final String SRCROOT_URI_BASE = "SRCROOT";
    @NotNull
    public static final String QODANA_JOB_URL = "QODANA_JOB_URL";
    @NotNull
    public static final String SUPPRESS_TOOL_ID_PARAMETER = "suppressToolId";
    public static final int REGION_LINES_COUNT_IF_PROBLEM_IS_FILE = 2;
    @NotNull
    public static final String QODANA_SEVERITY_KEY = "qodanaSeverity";

    @NotNull
    public static final SarifReport createSarifReport(@NotNull List<? extends Run> runs) {
        Intrinsics.checkNotNullParameter(runs, (String)"runs");
        URI schema = new URI("https://raw.githubusercontent.com/schemastore/schemastore/master/src/schemas/json/sarif-2.1.0-rtm.5.json");
        SarifReport sarifReport = new SarifReport(SarifReport.Version._2_1_0, runs).with$schema(schema);
        Intrinsics.checkNotNullExpressionValue((Object)sarifReport, (String)"SarifReport(SarifReport.\u2026ns).`with$schema`(schema)");
        return sarifReport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Run createRun(@NotNull Project project2, @NotNull QodanaInspectionApplication.LoadedProfile profile2) {
        void $this$createRun_u24lambda_u241;
        String string;
        String string2;
        PropertyBag it;
        PropertyBag propertyBag;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        ToolComponent driver = SarifKt.createDriver();
        Tool tool = new Tool(driver);
        String string3 = System.getProperty("qodana.automation.guid");
        if (string3 == null) {
            String string4 = UUID.randomUUID().toString();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
        }
        String runGUID = string3;
        PropertyBag propertyBag2 = propertyBag = new PropertyBag();
        RunAutomationDetails runAutomationDetails = new RunAutomationDetails().withGuid(runGUID).withId(SarifKt.buildReportId(project2));
        Run run2 = new Run(tool).withInvocations(CollectionsKt.listOf((Object)new Invocation(true).withExitCode(0)));
        boolean bl = false;
        Map map2 = it;
        String string5 = "jobUrl";
        String string6 = string2 = System.getenv(QODANA_JOB_URL);
        if (string6 == null) {
            string = "";
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"System.getenv(QODANA_JOB_URL) ?: \"\"");
            string = string2;
        }
        string2 = string;
        map2.put(string5, string2);
        Unit unit = Unit.INSTANCE;
        Run run3 = run2.withAutomationDetails(runAutomationDetails.withProperties(propertyBag));
        it = propertyBag = new PropertyBag();
        run2 = run3;
        boolean bl2 = false;
        $this$createRun_u24lambda_u241.put("deviceId", (Object)EventLogConfiguration.Companion.getInstance().getOrCreate("FUS").getDeviceId());
        $this$createRun_u24lambda_u241.put("configProfile", (Object)UsageCollector.Companion.profileForReporting(profile2.getNameForReporting(), profile2.getPathForReporting()));
        Run run4 = run2.withProperties(propertyBag);
        SarifReportContributor.runContributors(run4, project2);
        Intrinsics.checkNotNullExpressionValue((Object)run4, (String)"run");
        return run4;
    }

    private static final ToolComponent createDriver() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().build.productCode");
        String productCode = string;
        ToolComponent toolComponent = new ToolComponent(productCode).withFullName(QodanaKt.getQodanaProductName()).withVersion(appInfo.getBuild().asStringWithoutProductCode()).withRules(new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)toolComponent, (String)"ToolComponent(productCod\u2026ithRules(mutableListOf())");
        return toolComponent;
    }

    private static final String buildReportId(Project project2) {
        String string = System.getenv("QODANA_REPORT_ID");
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        String string2 = System.getenv("QODANA_PROJECT_ID");
        if (string2 == null) {
            String string3 = project2.getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.name");
        }
        String projectId = string2;
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String tool = "qodana";
        return projectId + "/" + tool + "/" + date;
    }

    @NotNull
    public static final Set<ToolComponent> createComponents(@NotNull QodanaRunner $this$createComponents, @NotNull ToolComponent driver) {
        Intrinsics.checkNotNullParameter((Object)$this$createComponents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        InspectionsTaxonomy taxonomy = new InspectionsTaxonomy();
        Map components = new LinkedHashMap();
        Collection collection = $this$createComponents.getRunContext().getQodanaProfile().getMainGroup().getProfile().getTools();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"runContext.qodanaProfile.mainGroup.profile.tools");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ToolComponent component2;
            InspectionToolWrapper defaultToolWrapper;
            ToolsImpl tools = (ToolsImpl)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)tools.getInspectionTool(null), (String)"tools.getInspectionTool(null)");
            defaultToolWrapper.getGroupPath();
            InspectionEP inspectionEP = defaultToolWrapper.getExtension();
            String pluginId = inspectionEP != null && (inspectionEP = inspectionEP.getPluginDescriptor()) != null && (inspectionEP = inspectionEP.getPluginId()) != null ? inspectionEP.getIdString() : null;
            InspectionEP inspectionEP2 = defaultToolWrapper.getExtension();
            String pluginVersion = inspectionEP2 != null && (inspectionEP2 = inspectionEP2.getPluginDescriptor()) != null ? inspectionEP2.getVersion() : null;
            Intrinsics.checkNotNullExpressionValue((Object)(pluginId != null ? (ToolComponent)components.computeIfAbsent(pluginId, new Function(pluginId, pluginVersion){
                final /* synthetic */ String $pluginId;
                final /* synthetic */ String $pluginVersion;
                {
                    this.$pluginId = $pluginId;
                    this.$pluginVersion = $pluginVersion;
                }

                @NotNull
                public final ToolComponent apply(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new ToolComponent(this.$pluginId).withVersion(this.$pluginVersion).withRules((List<ReportingDescriptor>)new ArrayList<E>());
                }
            }) : driver), (String)"pluginId = defaultToolWr\u2026else {\n      driver\n    }");
            component2 = component2;
            Pair<Integer, ReportingDescriptor> pair = taxonomy.addTool(defaultToolWrapper);
            int index = ((Number)pair.component1()).intValue();
            ReportingDescriptor descriptor = (ReportingDescriptor)pair.component2();
            List<ReportingDescriptor> list2 = component2.getRules();
            Intrinsics.checkNotNullExpressionValue((Object)tools, (String)"tools");
            String string = descriptor.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.id");
            list2.add(SarifKt.createRule(tools, index, string));
        }
        driver.setTaxa(taxonomy.getTaxonomy());
        return CollectionsKt.toSet((Iterable)components.values());
    }

    @NotNull
    public static final ReportingDescriptorRelationship createTaxonomyReference(int taxonomyIndex, @NotNull String taxonomyId) {
        Intrinsics.checkNotNullParameter((Object)taxonomyId, (String)"taxonomyId");
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().build.productCode");
        String productCode = string;
        ReportingDescriptorRelationship reportingDescriptorRelationship = new ReportingDescriptorRelationship(new ReportingDescriptorReference().withToolComponent(new ToolComponentReference().withName(productCode)).withId(taxonomyId).withIndex(taxonomyIndex)).withKinds(SetsKt.setOf((Object)"superset"));
        Intrinsics.checkNotNullExpressionValue((Object)reportingDescriptorRelationship, (String)"ReportingDescriptorRelat\u2026hKinds(setOf(\"superset\"))");
        return reportingDescriptorRelationship;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final ReportingDescriptor createRule(@NotNull ToolsImpl tools, int taxonomyIndex, @NotNull String taxonomyId) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)tools, (String)"tools");
            Intrinsics.checkNotNullParameter((Object)taxonomyId, (String)"taxonomyId");
            v0 = tools.getInspectionTool(null);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"tools.getInspectionTool(null)");
            defaultToolWrapper = v0;
            v1 = tools.getLevel().getSeverity();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"tools.level.severity");
            ideaSeverity = v1;
            v2 = tools.getLevel().getSeverity();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"tools.level.severity");
            sarifLevel = SarifKt.toLevel(v2);
            v3 = new ReportingConfiguration();
            if (!tools.isEnabled()) ** GOTO lbl-1000
            v4 = tools.getTools();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"tools.tools");
            var7_6 = v4;
            var13_7 = v3;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v5 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it /* !! */  = (ScopeToolState)element$iv;
                    $i$a$-any-SarifKt$createRule$defaultConfiguration$1 = false;
                    if (!it /* !! */ .isEnabled()) continue;
                    v5 = true;
                    break block9;
                }
                v5 = false;
            }
        }
        var14_14 = v5;
        v3 = var13_7;
        if (var14_14) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = false;
        }
        defaultConfiguration = v3.withEnabled(v6).withLevel(sarifLevel).withParameters(SarifKt.withSuppressToolId(SarifKt.withIdeaAndQodanaSeverities(new PropertyBag(), ideaSeverity.getName(), sarifLevel), defaultToolWrapper.getTool().getSuppressId()));
        reportingDescriptorRelationship = SarifKt.createTaxonomyReference(taxonomyIndex, taxonomyId);
        description = defaultToolWrapper.loadDescription();
        v7 = new ReportingDescriptor(tools.getShortName()).withShortDescription(new MultiformatMessageString().withText(defaultToolWrapper.getDisplayName()));
        v8 = new MultiformatMessageString();
        v9 = description;
        if (v9 != null) {
            it /* !! */  = v9;
            var14_15 = v8;
            var13_7 = v7;
            $i$a$-let-SarifKt$createRule$1 = false;
            var15_18 = Text_formatKt.htmlToPlainText(description);
            v7 = var13_7;
            v8 = var14_15;
            v10 = var15_18;
        } else {
            v10 = null;
        }
        v11 = v8.withText(v10);
        v12 = description;
        if (v12 != null) {
            it /* !! */  = v12;
            var14_16 = v11;
            var13_7 = v7;
            $i$a$-let-SarifKt$createRule$2 = false;
            var15_18 = Text_formatKt.htmlToMarkdown((String)it /* !! */ );
            v7 = var13_7;
            v11 = var14_16;
            v13 = var15_18;
        } else {
            v13 = null;
        }
        v14 = v7.withFullDescription(v11.withMarkdown(v13)).withRelationships(SetsKt.setOf((Object)reportingDescriptorRelationship)).withDefaultConfiguration(defaultConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"ReportingDescriptor(tool\u2026ion(defaultConfiguration)");
        return v14;
    }

    @NotNull
    public static final PropertyBag withIdeaAndQodanaSeverities(@NotNull PropertyBag $this$withIdeaAndQodanaSeverities, @Nullable String ideaSeverity, @NotNull Level sarifLevel) {
        String string;
        String string2;
        Map map2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$withIdeaAndQodanaSeverities, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)sarifLevel), (String)"sarifLevel");
                ((Map)$this$withIdeaAndQodanaSeverities).put("ideaSeverity", ideaSeverity);
                map2 = $this$withIdeaAndQodanaSeverities;
                string2 = QODANA_SEVERITY_KEY;
                string = ideaSeverity;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string3 = QodanaSeverity.Companion.fromIdeaSeverity(it).toString();
                string = string3;
                if (string3 != null) break block3;
            }
            string = QodanaSeverity.Companion.fromSarifLevel(sarifLevel).toString();
        }
        String string4 = string;
        map2.put(string2, string4);
        return $this$withIdeaAndQodanaSeverities;
    }

    @NotNull
    public static final PropertyBag withSuppressToolId(@NotNull PropertyBag $this$withSuppressToolId, @Nullable String suppressToolId) {
        Intrinsics.checkNotNullParameter((Object)$this$withSuppressToolId, (String)"<this>");
        ((Map)$this$withSuppressToolId).put(SUPPRESS_TOOL_ID_PARAMETER, suppressToolId);
        return $this$withSuppressToolId;
    }

    @NotNull
    public static final QodanaSeverity getQodanaSeverity(@NotNull Result $this$qodanaSeverity) {
        Object object;
        block8: {
            block7: {
                QodanaSeverity qodanaSeverity;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)$this$qodanaSeverity, (String)"<this>");
                    PropertyBag propertyBag = $this$qodanaSeverity.getProperties();
                    Object object2 = propertyBag != null ? propertyBag.get(QODANA_SEVERITY_KEY) : null;
                    object = object2 instanceof String ? (String)object2 : null;
                    if (object == null) break block7;
                    String qodanaSeverity2 = object;
                    boolean bl = false;
                    QodanaSeverity[] $this$firstOrNull$iv = QodanaSeverity.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        QodanaSeverity element$iv;
                        QodanaSeverity it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.toString(), (Object)qodanaSeverity2)) continue;
                        qodanaSeverity = element$iv;
                        break block6;
                    }
                    qodanaSeverity = null;
                }
                object = qodanaSeverity;
                if (qodanaSeverity != null) break block8;
            }
            PropertyBag propertyBag = $this$qodanaSeverity.getProperties();
            Object object3 = propertyBag != null ? propertyBag.get("ideaSeverity") : null;
            String string = object3 instanceof String ? (String)object3 : null;
            if (string != null) {
                String ideaSeverity = string;
                boolean bl = false;
                object = QodanaSeverity.Companion.fromIdeaSeverity(ideaSeverity);
            } else {
                Level level = $this$qodanaSeverity.getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)level), (String)"level");
                object = QodanaSeverity.Companion.fromSarifLevel(level);
            }
        }
        return object;
    }

    @NotNull
    public static final Level toLevel(@NotNull HighlightSeverity $this$toLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$toLevel, (String)"<this>");
        HighlightSeverity highlightSeverity = $this$toLevel;
        return Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR) ? Level.ERROR : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING) ? Level.WARNING : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING) ? Level.NOTE : Level.NOTE));
    }

    @NotNull
    public static final HighlightSeverity toSeverity(@NotNull Level $this$toSeverity) {
        HighlightSeverity highlightSeverity;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSeverity), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toSeverity.ordinal()]) {
            case 1: {
                HighlightSeverity highlightSeverity2 = HighlightSeverity.ERROR;
                highlightSeverity = highlightSeverity2;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity2, (String)"ERROR");
                break;
            }
            case 2: {
                HighlightSeverity highlightSeverity3 = HighlightSeverity.WARNING;
                highlightSeverity = highlightSeverity3;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity3, (String)"WARNING");
                break;
            }
            default: {
                HighlightSeverity highlightSeverity4 = HighlightSeverity.WEAK_WARNING;
                highlightSeverity = highlightSeverity4;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity4, (String)"WEAK_WARNING");
            }
        }
        return highlightSeverity;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object writeReport(@NotNull Path var0, @NotNull SarifReport var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof writeReport.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SarifKt.writeReport(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = path;
                $continuation.label = 1;
                v0 = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function0)((Function0)new Function0<Unit>(path, (SarifReport)report){
                    final /* synthetic */ Path $path;
                    final /* synthetic */ SarifReport $report;
                    {
                        this.$path = $path;
                        this.$report = $report;
                        super(0);
                    }

                    public final void invoke() {
                        Path path = this.$path.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path.parent");
                        PathKt.createDirectories((Path)path);
                        SarifUtil.writeReport(this.$path, this.$report);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                path = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (IOException e) {
                    SarifKt.LOG.error("Writing sarif report error. Path: " + path, (Throwable)e);
                }
lbl29:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String calcHash(@NotNull Result $this$calcHash) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$calcHash, (String)"<this>");
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"sha256().newHasher()");
        Hasher hasher2 = hasher;
        List<Location> list2 = $this$calcHash.getLocations();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"this.locations");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location it = (Location)element$iv;
            boolean bl = false;
            Location location = it;
            if (location == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"it");
            SarifKt.hash(it, hasher2);
        }
        Set<Graph> set = $this$calcHash.getGraphs();
        if (set != null) {
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Graph it = (Graph)element$iv;
                boolean bl = false;
                Graph graph = it;
                if (graph == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)graph, (String)"it");
                SarifKt.hash(it, hasher2);
            }
        }
        String string = $this$calcHash.getRuleId();
        if (string != null) {
            String string2;
            String $this$calcHash_u24lambda_u2413 = string2 = string;
            boolean bl = false;
            hasher2.putUnencodedChars((CharSequence)$this$calcHash_u24lambda_u2413);
        }
        if ((object = $this$calcHash.getMessage()) != null && (object = ((Message)object).getText()) != null) {
            Object object2;
            Object $this$calcHash_u24lambda_u2414 = object2 = object;
            boolean bl = false;
            hasher2.putUnencodedChars((CharSequence)$this$calcHash_u24lambda_u2414);
        }
        String string3 = hasher2.hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hasher.hash().toString()");
        return string3;
    }

    public static final void hash(@NotNull Location $this$hash, @NotNull Hasher hasher) {
        block11: {
            Object object;
            Object object2;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
            Object object6 = $this$hash.getPhysicalLocation();
            if (object6 != null && (object6 = ((PhysicalLocation)object6).getArtifactLocation()) != null && (object6 = ((ArtifactLocation)object6).getUri()) != null) {
                Iterator $this$hash_u24lambda_u2415 = iterator = object6;
                boolean bl = false;
                hasher.putUnencodedChars((CharSequence)((Object)$this$hash_u24lambda_u2415));
            }
            if ((object5 = $this$hash.getPhysicalLocation()) != null && (object5 = ((PhysicalLocation)object5).getArtifactLocation()) != null && (object5 = ((ArtifactLocation)object5).getUriBaseId()) != null) {
                Iterator $this$hash_u24lambda_u2416 = iterator = object5;
                boolean bl = false;
                hasher.putUnencodedChars((CharSequence)((Object)$this$hash_u24lambda_u2416));
            }
            if ((object4 = $this$hash.getPhysicalLocation()) != null && (object4 = ((PhysicalLocation)object4).getRegion()) != null) {
                SarifKt.hash((Region)object4, hasher);
            }
            if ((object3 = $this$hash.getPhysicalLocation()) != null && (object3 = ((PhysicalLocation)object3).getContextRegion()) != null) {
                SarifKt.hash((Region)object3, hasher);
            }
            Set<LogicalLocation> set = $this$hash.getLogicalLocations();
            if (set != null) {
                $this$forEach$iv = set;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object7;
                    Object object8;
                    LogicalLocation it = (LogicalLocation)element$iv;
                    boolean bl = false;
                    Object object9 = it;
                    if (object9 != null && (object9 = (object2 = ((LogicalLocation)object9).getName())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"name");
                        object = object2;
                        String $this$hash_u24lambda_u2420_u24lambda_u2417 = object;
                        boolean bl2 = false;
                        hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2420_u24lambda_u2417);
                    }
                    if ((object8 = it) != null && (object8 = (object2 = ((LogicalLocation)object8).getFullyQualifiedName())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"fullyQualifiedName");
                        Object $this$hash_u24lambda_u2420_u24lambda_u2418 = object = object2;
                        boolean bl3 = false;
                        hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2420_u24lambda_u2418);
                    }
                    if ((object7 = it) == null || (object7 = (object2 = ((LogicalLocation)object7).getKind())) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"kind");
                    Object $this$hash_u24lambda_u2420_u24lambda_u2419 = object = object2;
                    boolean bl4 = false;
                    hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2420_u24lambda_u2419);
                }
            }
            Set<LocationRelationship> set2 = $this$hash.getRelationships();
            if (set2 == null) break block11;
            $this$forEach$iv = set2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object10;
                LocationRelationship relationship = (LocationRelationship)element$iv;
                boolean bl = false;
                Object object11 = relationship;
                if (object11 != null && (object11 = (object2 = ((LocationRelationship)object11).getKinds())) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"kinds");
                    Iterable $this$forEach$iv2 = (Iterable)object2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String it = (String)element$iv2;
                        boolean bl5 = false;
                        hasher.putUnencodedChars((CharSequence)it);
                    }
                }
                if ((object10 = relationship) == null || (object10 = (object2 = ((LocationRelationship)object10).getTarget())) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"target");
                object = object2;
                int $this$hash_u24lambda_u2423_u24lambda_u2422 = ((Number)object).intValue();
                boolean bl6 = false;
                hasher.putInt($this$hash_u24lambda_u2423_u24lambda_u2422);
            }
        }
    }

    public static final void hash(@NotNull Region $this$hash, @NotNull Hasher hasher) {
        block5: {
            Object object;
            Object object2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
            String string = $this$hash.getSourceLanguage();
            if (string != null) {
                object3 = string;
                String $this$hash_u24lambda_u2424 = object3;
                boolean bl = false;
                hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2424);
            }
            Integer n = $this$hash.getStartLine();
            if (n != null) {
                object3 = n;
                int $this$hash_u24lambda_u2425 = ((Number)object3).intValue();
                boolean bl = false;
                hasher.putInt($this$hash_u24lambda_u2425);
            }
            Integer n2 = $this$hash.getStartColumn();
            if (n2 != null) {
                object3 = n2;
                int $this$hash_u24lambda_u2426 = ((Number)object3).intValue();
                boolean bl = false;
                hasher.putInt($this$hash_u24lambda_u2426);
            }
            Integer n3 = $this$hash.getCharLength();
            if (n3 != null) {
                object3 = n3;
                int $this$hash_u24lambda_u2427 = ((Number)object3).intValue();
                boolean bl = false;
                hasher.putInt($this$hash_u24lambda_u2427);
            }
            Integer n4 = $this$hash.getCharOffset();
            if (n4 != null) {
                object3 = n4;
                int $this$hash_u24lambda_u2428 = ((Number)object3).intValue();
                boolean bl = false;
                hasher.putInt($this$hash_u24lambda_u2428);
            }
            if ((object2 = $this$hash.getSnippet()) == null || (object2 = ((ArtifactContent)object2).getText()) == null) break block5;
            Object $this$hash_u24lambda_u2429 = object = object2;
            boolean bl = false;
            hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2429);
        }
    }

    public static final void hash(@NotNull Graph $this$hash, @NotNull Hasher hasher) {
        block9: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
            Set<Node> set = $this$hash.getNodes();
            if (set != null) {
                $this$forEach$iv = set;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Collection<Map.Entry<String, Object>> collection;
                    Object object5;
                    Node node = (Node)element$iv;
                    boolean bl = false;
                    Object object6 = node;
                    if (object6 != null && (object6 = (object4 = ((Node)object6).getId())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"id");
                        object3 = object4;
                        Set<Map.Entry<String, Object>> $this$hash_u24lambda_u2433_u24lambda_u2430 = object3;
                        boolean bl2 = false;
                        hasher.putUnencodedChars((CharSequence)((Object)$this$hash_u24lambda_u2433_u24lambda_u2430));
                    }
                    if ((object5 = node) != null && (object5 = (object4 = ((Node)object5).getLocation())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"location");
                        SarifKt.hash(object4, hasher);
                    }
                    if ((collection = node) == null || (collection = ((Node)((Object)collection)).getProperties()) == null || (collection = (object3 = ((PropertyBag)((Object)collection)).entrySet())) == null) continue;
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"entries");
                    Iterable $this$sortedBy$iv = (Iterable)object3;
                    boolean $i$f$sortedBy = false;
                    collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Map.Entry it = (Map.Entry)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                            it = (Map.Entry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                        }
                    });
                    if (collection == null) continue;
                    Iterable $this$forEach$iv2 = collection;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Map.Entry it = (Map.Entry)element$iv2;
                        boolean bl3 = false;
                        hasher.putUnencodedChars((CharSequence)it.getKey());
                        hasher.putInt(it.getValue().hashCode());
                    }
                }
            }
            Set<Edge> set2 = $this$hash.getEdges();
            if (set2 != null) {
                $this$forEach$iv = set2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object7;
                    Object object8;
                    Edge it = (Edge)element$iv;
                    boolean bl = false;
                    Object object9 = it;
                    if (object9 != null && (object9 = (object4 = ((Edge)object9).getId())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"id");
                        object3 = object4;
                        Set<Map.Entry<String, Object>> $this$hash_u24lambda_u2437_u24lambda_u2434 = object3;
                        boolean bl4 = false;
                        hasher.putUnencodedChars((CharSequence)((Object)$this$hash_u24lambda_u2437_u24lambda_u2434));
                    }
                    if ((object8 = it) != null && (object8 = (object4 = ((Edge)object8).getSourceNodeId())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"sourceNodeId");
                        Object $this$hash_u24lambda_u2437_u24lambda_u2435 = object3 = object4;
                        boolean bl5 = false;
                        hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2437_u24lambda_u2435);
                    }
                    if ((object7 = it) == null || (object7 = (object4 = ((Edge)object7).getTargetNodeId())) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"targetNodeId");
                    Object $this$hash_u24lambda_u2437_u24lambda_u2436 = object3 = object4;
                    boolean bl6 = false;
                    hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2437_u24lambda_u2436);
                }
            }
            if ((object2 = $this$hash.getDescription()) == null || (object2 = ((Message)object2).getText()) == null) break block9;
            Object $this$hash_u24lambda_u2438 = object = object2;
            boolean bl = false;
            hasher.putUnencodedChars((CharSequence)$this$hash_u24lambda_u2438);
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final PhysicalLocation getPhysicalLocation(@NotNull CommonDescriptor problem, @NotNull PathMacroManager macroManager, int linesMargin) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
            artifactLocation = SarifKt.getArtifactLocation(problem.getFile());
            physicalLocation = new PhysicalLocation().withArtifactLocation(artifactLocation);
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(macroManager.expandPath(problem.getFile()));
            text = SarifKt.loadTextFromVirtualFile(virtualFile);
            fileLanguage = LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
            if (text == null) break block5;
            v0 = problem.getLength();
            if (v0 == null || text.length() != v0.intValue()) ** GOTO lbl-1000
            v1 = problem.getLine();
            var9_8 = 1;
            if (v1 == null || v1 != var9_8) ** GOTO lbl-1000
            v2 = problem.getColumn();
            if (v2 != null && v2 == 0) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = problemIsFile = false;
            }
            if (problemIsFile) {
                border = new Border(0, 0, text, new IntRange(0, 2));
                borderMoved = true;
                while (border.getCurrentOffset() < text.length() && borderMoved) {
                    borderMoved = border.moveRight();
                }
                fixedProblem = CommonDescriptor.copy$default(problem, null, null, null, border.getCurrentOffset(), null, null, 55, null);
                physicalLocation.withRegion(SarifKt.getRegion(fixedProblem, text)).withContextRegion(ContextRegionKt.getContextRegion(fixedProblem, text, linesMargin, fileLanguage));
            } else {
                physicalLocation.withRegion(SarifKt.getRegion(problem, text)).withContextRegion(ContextRegionKt.getContextRegion(problem, text, linesMargin, fileLanguage));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)physicalLocation, (String)"physicalLocation");
        return physicalLocation;
    }

    @Nullable
    public static final ArtifactLocation getArtifactLocation(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return StringsKt.startsWith$default((String)fileUrl, (String)PROJECT_DIR_PREFIX, (boolean)false, (int)2, null) ? new ArtifactLocation().withUri(StringsKt.removePrefix((String)fileUrl, (CharSequence)PROJECT_DIR_PREFIX)).withUriBaseId(SRCROOT_URI_BASE) : new ArtifactLocation().withUri(fileUrl);
    }

    @Nullable
    public static final Region getRegion(@NotNull CommonDescriptor problem, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return SarifKt.getRegionByOffset(problem, text2, ContextRegionKt.getProblemOffset(text2, problem));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Region getRegionByOffset(@NotNull CommonDescriptor problem, @NotNull String text2, @Nullable Integer offset) {
        Integer n;
        String string;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (offset == null || problem.getLine() == null) {
            return null;
        }
        if (problem.getLength() != null && text2.length() >= offset + problem.getLength()) {
            int n2 = offset;
            String string2 = text2.substring(n2, offset + problem.getLength());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = problem.getHighlightedElement();
        }
        String snippet = string;
        Region region = new Region().withCharOffset(offset);
        Integer n3 = problem.getColumn();
        if (n3 != null) {
            void it;
            int n4 = ((Number)n3).intValue();
            Region region2 = region;
            boolean bl = false;
            n = (int)(it + true);
            region = region2;
        } else {
            n = null;
        }
        return region.withStartColumn(n).withCharLength(problem.getLength()).withStartLine(problem.getLine()).withSourceLanguage(problem.getLanguage()).withSnippet(new ArtifactContent().withText(snippet));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Fix> constructFixes(@NotNull ProblemDescriptor problemDescriptor, @NotNull ArtifactLocation location, @NotNull Project project2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object[] objectArray = problemDescriptor.getFixes();
        if (objectArray == null) {
            return SetsKt.emptySet();
        }
        Object[] fixes = objectArray;
        List actions2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ArraysKt.getIndices((Object[])fixes))), (Function1)((Function1)new Function1<Integer, IntentionAction>(problemDescriptor){
            final /* synthetic */ ProblemDescriptor $problemDescriptor;
            {
                this.$problemDescriptor = $problemDescriptor;
                super(1);
            }

            @NotNull
            public final IntentionAction invoke(int it) {
                return QuickFixWrapper.wrap((ProblemDescriptor)this.$problemDescriptor, (int)it);
            }
        })));
        Iterable $this$mapNotNull$iv = actions2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Fix it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IntentionAction it = (IntentionAction)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            PsiFile psiFile2 = problemDescriptor.getPsiElement().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"problemDescriptor.psiElement.containingFile");
            if (SarifKt.chooseFix(it, location, psiFile2, project2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Fix chooseFix(IntentionAction action, ArtifactLocation location, PsiFile file, Project project2) {
        PsiFile psiFile2 = IntentionPreviewUtils.obtainCopyForPreview((PsiFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"obtainCopyForPreview(file)");
        PsiFile fileCopy = psiFile2;
        Pair<IntentionPreviewInfo, String> pair = FixesKt.genPreview(action, fileCopy, file, project2);
        if (pair == null) {
            return null;
        }
        Pair<IntentionPreviewInfo, String> pair2 = pair;
        IntentionPreviewInfo previewInfo = (IntentionPreviewInfo)pair2.component1();
        String newText = (String)pair2.component2();
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance()");
        ComparisonManager comparisonManager2 = comparisonManager;
        ComparisonPolicy policy = Intrinsics.areEqual((Object)previewInfo, (Object)IntentionPreviewInfo.DIFF) ? ComparisonPolicy.TRIM_WHITESPACES : ComparisonPolicy.DEFAULT;
        List list2 = comparisonManager2.compareLines((CharSequence)file.getText(), (CharSequence)newText, policy, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"comparisonManager.compar\u2026ogressIndicator.INSTANCE)");
        List fragments = list2;
        return new Fix(SetsKt.setOf((Object)SarifKt.constructArtifactChange(fragments, location, newText)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArtifactChange constructArtifactChange(@NotNull List<? extends LineFragment> fragments, @NotNull ArtifactLocation location, @NotNull String text2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Iterable iterable = fragments;
        ArtifactLocation artifactLocation = location;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LineFragment lineFragment = (LineFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SarifKt.constructReplacement((LineFragment)it, text2));
        }
        List list2 = (List)destination$iv$iv;
        ArtifactLocation artifactLocation2 = artifactLocation;
        return new ArtifactChange(artifactLocation2, list2);
    }

    @NotNull
    public static final Replacement constructReplacement(@NotNull LineFragment fragment, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Replacement replacement = new Replacement(new Region().withCharOffset(fragment.getStartOffset1()).withCharLength(fragment.getEndOffset1() - fragment.getStartOffset1()));
        int insertLen = fragment.getEndOffset2() - fragment.getStartOffset2();
        if (insertLen > 0) {
            ArtifactContent artifactContent = new ArtifactContent();
            String string = text2.substring(fragment.getStartOffset2(), fragment.getEndOffset2());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Replacement replacement2 = replacement.withInsertedContent(artifactContent.withText(string));
            Intrinsics.checkNotNullExpressionValue((Object)replacement2, (String)"replacement.withInserted\u20262, fragment.endOffset2)))");
            return replacement2;
        }
        return replacement;
    }

    @Nullable
    public static final String loadTextFromVirtualFile(@Nullable VirtualFile virtualFile2) {
        return virtualFile2 != null && !virtualFile2.isDirectory() ? VfsUtil.loadText((VirtualFile)virtualFile2) : null;
    }

    @NotNull
    public static final Gson createGson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)PropertyBag.class), (Object)new PropertyBag.PropertyBagTypeAdapter().nullSafe()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n    .setPr\u2026er().nullSafe()).create()");
        return gson;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SarifReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

