/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParameters;", "", "scriptName", "", "parameters", "", "(Ljava/lang/String;Ljava/util/Map;)V", "remaining", "", "done", "", "optional", "name", "required", "intellij.qodana"})
public final class UnvalidatedParameters {
    @NotNull
    private final String scriptName;
    @NotNull
    private final Map<String, String> remaining;

    public UnvalidatedParameters(@NotNull String scriptName, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.scriptName = scriptName;
        this.remaining = MapsKt.toMutableMap(parameters);
    }

    @NotNull
    public final String required(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.remaining.remove(name);
        if (string == null) {
            throw new QodanaException("Script '" + this.scriptName + "' requires parameter '" + name + "'");
        }
        return string;
    }

    @Nullable
    public final String optional(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.remaining.remove(name);
    }

    public final void done() {
        if (this.remaining.isEmpty()) {
            return;
        }
        String parameters = this.remaining.size() == 1 ? "parameter" : "parameters";
        String unknown = CollectionsKt.joinToString$default((Iterable)this.remaining.keySet(), null, null, null, (int)0, null, null, (int)63, null);
        throw new QodanaException("Script '" + this.scriptName + "' cannot handle " + parameters + " '" + unknown + "'");
    }
}

