/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.ToolbarComboWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.PerforceToolbarWidgetHelper;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J&\u0010\u0003\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "()V", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "popupFactory", "Lcom/intellij/openapi/ui/popup/JBPopupFactory;", "step", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "", "createStep", "widget", "Lcom/intellij/openapi/wm/impl/ToolbarComboWidget;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Companion", "intellij.vcs.perforce"})
public final class PerforceToolbarWidgetAction
extends ExpandableComboAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> isConnectedKey;
    @NotNull
    private static final Key<String> workspaceKey;
    @NotNull
    private static final Key<Boolean> statusKey;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    protected JBPopup createPopup(@NotNull AnActionEvent event) {
        Object action;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        AnAction anAction = ActionManager.getInstance().getAction("Perforce.Toolbar");
        ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup == null) {
            return null;
        }
        ActionGroup toolbarActions = actionGroup;
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(toolbarActions);
        group.addSeparator(PerforceBundle.message("action.Perforce.Toolbar.workspaces.label", new Object[0]));
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project2);
        Collection<P4Connection> allConnections = perforceSettings.getAllConnections();
        for (P4Connection connection : allConnections) {
            String string = connection.getConnectionKey().getClient();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.connectionKey.client");
            String string2 = connection.getWorkingDir();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.workingDir");
            action = new PerforceToolbarWidgetHelper.WorkspaceAction(string, string2);
            group.add((AnAction)action);
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        action = event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        ToolbarComboWidget widget = action instanceof ToolbarComboWidget ? (ToolbarComboWidget)action : null;
        Intrinsics.checkNotNullExpressionValue((Object)popupFactory, (String)"popupFactory");
        ActionGroup actionGroup2 = (ActionGroup)group;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"event.dataContext");
        ListPopupStep<Object> step = this.createStep(popupFactory, widget, actionGroup2, dataContext);
        return (JBPopup)this.createPopup(project2, popupFactory, step);
    }

    private final ListPopupStep<Object> createStep(JBPopupFactory popupFactory, ToolbarComboWidget widget, ActionGroup actionGroup, DataContext context) {
        ListPopupStep listPopupStep = popupFactory.createActionsStep(actionGroup, context, "ProjectWidgetPopup", false, true, null, (Component)widget, false, 0, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopupStep, (String)"popupFactory.createActio\u2026 widget, false, 0, false)");
        return listPopupStep;
    }

    private final ListPopup createPopup(Project project, JBPopupFactory popupFactory, ListPopupStep<Object> step) {
        Function<ListCellRenderer, ListCellRenderer> renderer = PerforceToolbarWidgetAction::createPopup$lambda$0;
        ListPopup listPopup = popupFactory.createListPopup(project, step, renderer);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"popupFactory.createListP\u2026(project, step, renderer)");
        return listPopup;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !PerforceManager.getInstance(project).isActive() || !PerforceConnectionManager.getInstance(project).isInitialized()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        Intrinsics.checkNotNullExpressionValue((Object)perforceSettings, (String)"perforceSettings");
        P4Connection connection = PerforceToolbarWidgetHelper.Companion.getConnection(e, perforceSettings);
        Object object = connection;
        String workspace = object != null && (object = object.getConnectionKey()) != null ? ((ConnectionKey)object).getClient() : null;
        boolean isNoConnections = perforceSettings.getAllConnections().isEmpty();
        Presentation $this$update_u24lambda_u241 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u241.setDescription(PerforceToolbarWidgetHelper.Companion.getDescription(workspace, isNoConnections, perforceSettings.ENABLED));
        $this$update_u24lambda_u241.setEnabledAndVisible(true);
        $this$update_u24lambda_u241.setIcon(PerforceToolbarWidgetHelper.Companion.getIcon(perforceSettings, isNoConnections, true));
        $this$update_u24lambda_u241.putClientProperty(workspaceKey, (Object)workspace);
        $this$update_u24lambda_u241.putClientProperty(isConnectedKey, (Object)(!isNoConnections ? 1 : 0));
        $this$update_u24lambda_u241.putClientProperty(statusKey, (Object)perforceSettings.ENABLED);
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        ToolbarComboWidget toolbarComboWidget = component instanceof ToolbarComboWidget ? (ToolbarComboWidget)component : null;
        if (toolbarComboWidget == null) {
            return;
        }
        ToolbarComboWidget widget = toolbarComboWidget;
        Boolean bl = (Boolean)presentation.getClientProperty(isConnectedKey);
        if (bl == null) {
            bl = false;
        }
        boolean isConnected = bl;
        String workspace = (String)presentation.getClientProperty(workspaceKey);
        Boolean bl2 = (Boolean)presentation.getClientProperty(statusKey);
        if (bl2 == null) {
            bl2 = false;
        }
        boolean isOnline = bl2;
        String text = PerforceToolbarWidgetHelper.Companion.getText(workspace, !isConnected, isOnline);
        widget.setExpandable(isConnected);
        widget.setText(text);
        widget.setToolTipText(presentation.getDescription());
        widget.setLeftIcons(CollectionsKt.listOfNotNull((Object)presentation.getIcon()));
    }

    private static final ListCellRenderer createPopup$lambda$0(ListCellRenderer base) {
        return base;
    }

    static {
        Key key = Key.create((String)"P4_IS_CONNECTED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<Boolean>(\"P4_IS_CONNECTED\")");
        isConnectedKey = key;
        Key key2 = Key.create((String)"P4_WORKSPACE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create<@NlsSafe String>(\"P4_WORKSPACE\")");
        workspaceKey = key2;
        Key key3 = Key.create((String)"P4_STATUS");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create<Boolean>(\"P4_STATUS\")");
        statusKey = key3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u001f\u0012\u0016\u0012\u0014 \u0006*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000b0\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetAction$Companion;", "", "()V", "isConnectedKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "statusKey", "workspaceKey", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

