/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ClientRootsCache {
    private static final Logger LOG = Logger.getInstance(ClientRootsCache.class);
    private final Map<String, String> myRawToCanonical = new HashMap<String, String>();
    private final Map<String, String> myCanonicalToRaw = new HashMap<String, String>();
    private final Object myLock = new Object();

    public static ClientRootsCache getClientRootsCache(Project project) {
        return (ClientRootsCache)project.getService(ClientRootsCache.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String putGet(String rawClientRoot) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myRawToCanonical.containsKey(rawClientRoot)) {
                String converted = ClientRootsCache.correctCase(rawClientRoot);
                LOG.debug("canonicalize " + rawClientRoot + " to " + converted);
                this.myCanonicalToRaw.put(converted, rawClientRoot);
                this.myRawToCanonical.put(rawClientRoot, converted);
            }
            return this.myRawToCanonical.get(rawClientRoot);
        }
    }

    private static String correctCase(String rawClientRoot) {
        String converted = rawClientRoot;
        if (SystemInfo.isWindows && !"null".equals(rawClientRoot) && !ClientRootsCache.isUnixPath(rawClientRoot)) {
            File root = new File(rawClientRoot);
            try {
                converted = root.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (rawClientRoot.endsWith(":") && rawClientRoot.length() == 2) {
                converted = StringUtil.trimEnd((String)converted, (String)File.separator);
            }
        }
        return converted;
    }

    private static boolean isUnixPath(String root) {
        return root.startsWith("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRaw(@Nullable String converted) {
        Object object = this.myLock;
        synchronized (object) {
            String was = this.myCanonicalToRaw.get(converted);
            return was == null ? converted : was;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String convertPath(@Nullable String convertedClientRoot, @NotNull String s) {
        if (s == null) {
            ClientRootsCache.$$$reportNull$$$0(0);
        }
        String trimmed = s.trim();
        Object object = this.myLock;
        synchronized (object) {
            if (convertedClientRoot != null) {
                String rawRoot = this.myCanonicalToRaw.get(convertedClientRoot);
                if (rawRoot != null && FileUtil.startsWith((String)trimmed, (String)rawRoot)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("convertPath " + trimmed + " with rawRoot " + rawRoot + ", convertedClientRoot=" + convertedClientRoot);
                    }
                    return ClientRootsCache.glueRelativePath(convertedClientRoot, trimmed.substring(rawRoot.length()));
                }
                return trimmed;
            }
            for (String raw : this.myRawToCanonical.keySet()) {
                if (!FileUtil.startsWith((String)trimmed, (String)raw)) continue;
                String canonical = this.myRawToCanonical.get(raw);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("convertPath " + trimmed + " with raw=" + raw + ", canonical=" + canonical);
                }
                return ClientRootsCache.glueRelativePath(canonical, trimmed.substring(raw.length()));
            }
            return trimmed;
        }
    }

    private static String glueRelativePath(String absPath, String relativePath) {
        if (absPath.endsWith("\\") || absPath.endsWith("/") || relativePath.startsWith("\\") || relativePath.startsWith("/")) {
            return absPath + relativePath;
        }
        return absPath + File.separator + relativePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/perforce/application/ClientRootsCache", "convertPath"));
    }
}

