/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.error;

import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.ide.BrowserUtil;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusError;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusErrorKt;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDataException;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/error/GitLabMergeRequestErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter;", "", "accountVm", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountViewModel;", "(Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountViewModel;)V", "getErrorAction", "Ljavax/swing/Action;", "error", "getErrorDescription", "", "Lorg/jetbrains/annotations/Nls;", "getErrorTitle", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestErrorStatusPresenter
implements ErrorStatusPresenter<Throwable> {
    @NotNull
    private final GitLabAccountViewModel accountVm;

    public GitLabMergeRequestErrorStatusPresenter(@NotNull GitLabAccountViewModel accountVm) {
        Intrinsics.checkNotNullParameter((Object)accountVm, (String)"accountVm");
        this.accountVm = accountVm;
    }

    @NotNull
    public String getErrorTitle(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return GitLabBundle.message("merge.request.list.error", new Object[0]);
    }

    @NotNull
    public String getErrorDescription(@NotNull Throwable error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof HttpStatusErrorException) {
            GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
            if (gitLabHttpStatusError == null) {
                return ((HttpStatusErrorException)error).getLocalizedMessage();
            }
            GitLabHttpStatusError actualError = gitLabHttpStatusError;
            String string2 = switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                case 1 -> CollaborationToolsBundle.message((String)"http.status.error.refresh.token", (Object[])new Object[0]);
                case 2 -> CollaborationToolsBundle.message((String)"http.request.error", (Object[])new Object[0]) + "\n" + actualError.getError();
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        val actualErro\u2026r.error\n        }\n      }");
            string = string2;
        } else if (throwable instanceof GitLabMergeRequestDataException.EmptySourceProject) {
            String string3 = ((GitLabMergeRequestDataException.EmptySourceProject)error).getLocalizedMessage();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"error.localizedMessage");
        } else {
            String string4 = error.getLocalizedMessage();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"error.localizedMessage");
        }
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull Throwable error) {
        Action action;
        block6: {
            Throwable throwable;
            block5: {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                throwable = error;
                if (!(throwable instanceof HttpStatusErrorException)) break block5;
                GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
                if (gitLabHttpStatusError == null) {
                    return null;
                }
                GitLabHttpStatusError actualError = gitLabHttpStatusError;
                switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                    case 1: {
                        action = this.accountVm.loginAction();
                        break block6;
                    }
                    case 2: {
                        action = null;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            action = throwable instanceof GitLabMergeRequestDataException.EmptySourceProject ? (Action)ActionUtilKt.swingAction((String)GitLabBundle.message("group.GitLab.Open.In.Browser.text", new Object[0]), (Function1)((Function1)new Function1<ActionEvent, Unit>(error){
                final /* synthetic */ Throwable $error;
                {
                    this.$error = $error;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BrowserUtil.browse((String)((GitLabMergeRequestDataException.EmptySourceProject)this.$error).getUrl());
                }
            })) : null;
        }
        return action;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabHttpStatusError.HttpStatusErrorType.values().length];
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.INVALID_TOKEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

