/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorFindAction;
import training.featuresSuggester.actions.EditorFocusGainedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006'"}, d2={"Ltraining/featuresSuggester/suggesters/FileStructureSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "()V", "id", "", "getId", "()Ljava/lang/String;", "languages", "", "getLanguages", "()Ljava/util/List;", "message", "getMessage", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "prevActionIsEditorFindAction", "", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "suggestingActionId", "getSuggestingActionId", "suggestingTipId", "getSuggestingTipId", "getFindModel", "Lcom/intellij/find/FindModel;", "project", "Lcom/intellij/openapi/project/Project;", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "getDefinitionOnCaret", "Lcom/intellij/psi/PsiElement;", "Ltraining/featuresSuggester/SuggesterSupport;", "psiFile", "Lcom/intellij/psi/PsiFile;", "caretOffset", "intellij.featuresTrainer"})
public final class FileStructureSuggester
extends AbstractFeatureSuggester {
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("file.structure.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("file.structure.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingTipId = this.getSuggestingActionId();
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages;
    private boolean prevActionIsEditorFindAction;

    public FileStructureSuggester() {
        this.id = "File structure";
        this.suggestingActionId = "FileStructurePopup";
        this.minSuggestingIntervalDays = 14;
        Object[] objectArray = new String[]{"JAVA", "kotlin", "Python", "JavaScript", "ECMAScript 6"};
        this.languages = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingTipId() {
        return this.suggestingTipId;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Language language = action2.getLanguage();
        if (language == null) {
            return NoSuggestion.INSTANCE;
        }
        Language language2 = language;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage(language2);
        if (suggesterSupport == null) {
            return NoSuggestion.INSTANCE;
        }
        SuggesterSupport langSupport2 = suggesterSupport;
        Action action3 = action2;
        if (action3 instanceof EditorFindAction) {
            this.prevActionIsEditorFindAction = true;
        } else if (action3 instanceof EditorFocusGainedAction) {
            if (!this.prevActionIsEditorFindAction) {
                return NoSuggestion.INSTANCE;
            }
            PsiFile psiFile2 = ((EditorFocusGainedAction)action2).getPsiFile();
            if (psiFile2 == null) {
                return NoSuggestion.INSTANCE;
            }
            PsiFile psiFile3 = psiFile2;
            Project project = action2.getProject();
            if (project == null) {
                return NoSuggestion.INSTANCE;
            }
            Project project2 = project;
            FindModel findModel = this.getFindModel(project2);
            String string = findModel.getStringToFind();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"findModel.stringToFind");
            String textToFind = string;
            PsiElement definition = this.getDefinitionOnCaret(langSupport2, psiFile3, ((EditorFocusGainedAction)action2).getEditor().getCaretModel().getOffset());
            if (definition instanceof PsiNamedElement && langSupport2.isFileStructureElement(definition)) {
                String string2 = ((PsiNamedElement)definition).getName();
                boolean bl = string2 != null ? StringsKt.contains((CharSequence)string2, (CharSequence)textToFind, (!findModel.isCaseSensitive() ? 1 : 0) != 0) : false;
                if (bl) {
                    this.prevActionIsEditorFindAction = false;
                    return this.createSuggestion();
                }
            }
        } else {
            this.prevActionIsEditorFindAction = false;
        }
        return NoSuggestion.INSTANCE;
    }

    private final PsiElement getDefinitionOnCaret(SuggesterSupport $this$getDefinitionOnCaret, PsiFile psiFile2, int caretOffset) {
        int offset = caretOffset - 1;
        if (offset < 0) {
            return null;
        }
        PsiElement curElement = psiFile2.findElementAt(offset);
        return curElement != null && $this$getDefinitionOnCaret.isIdentifier(curElement) ? curElement.getParent() : null;
    }

    private final FindModel getFindModel(Project project) {
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel findModel = new FindModel();
        findModel.copyFrom(findManager.getFindInFileModel());
        return findModel;
    }
}

