/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.api.BuildFileProvider;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.extension.python.PyPIProjectDependenciesModel;
import org.jetbrains.security.extension.python.RequirementsTxtBuildFileProvider;
import org.jetbrains.security.service.PackageCheckerDisposable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/security/extension/python/RequirementsTxtDependenciesModel;", "Lorg/jetbrains/security/extension/python/PyPIProjectDependenciesModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildFileName", "", "getBuildFileName", "()Ljava/lang/String;", "declaredDependencies", "", "Lorg/jetbrains/security/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findCorrespondingBuildFileProvider", "Lorg/jetbrains/security/extension/python/RequirementsTxtBuildFileProvider;", "getBuildFileSpecificRequirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "supports", "", "intellij.packageChecker"})
public final class RequirementsTxtDependenciesModel
extends PyPIProjectDependenciesModel {
    @NotNull
    private final Project project;
    @NotNull
    private final String buildFileName;

    public RequirementsTxtDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = PyPackageManager.PACKAGE_MANAGER_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"PACKAGE_MANAGER_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> RequirementsTxtDependenciesModel._init_$lambda$0(this, arg_0));
        this.buildFileName = "requirements.txt";
    }

    @Override
    @NotNull
    public String getBuildFileName() {
        return this.buildFileName;
    }

    @Override
    @Nullable
    public VirtualFile findBuildFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return PyPackageUtil.findRequirementsTxt((Module)module);
    }

    @Override
    @NotNull
    public List<PyRequirement> getBuildFileSpecificRequirements(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List list = (List)ReadAction.compute(() -> RequirementsTxtDependenciesModel.getBuildFileSpecificRequirements$lambda$1(module));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.findCorrespondingBuildFileProvider().supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.findCorrespondingBuildFileProvider().supports(module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.findCorrespondingBuildFileProvider().declaredDependencies(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.findCorrespondingBuildFileProvider().declaredDependencies(module);
    }

    @Override
    @NotNull
    public RequirementsTxtBuildFileProvider findCorrespondingBuildFileProvider() {
        return (RequirementsTxtBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(RequirementsTxtBuildFileProvider.class, (AreaInstance)this.project);
    }

    private static final void _init_$lambda$0(RequirementsTxtDependenciesModel this$0, Sdk it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refresh(this$0.project);
    }

    private static final List getBuildFileSpecificRequirements$lambda$1(Module $module) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        return PyPackageUtil.getRequirementsFromTxt((Module)$module);
    }
}

