/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.toolwindow.tree;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.service.PackageCheckerDisposable;
import org.jetbrains.security.toolwindow.ProjectDependencyView;
import org.jetbrains.security.toolwindow.controller.PackageCheckerViewService;
import org.jetbrains.security.toolwindow.tree.DependencyTreePanel;
import org.jetbrains.security.toolwindow.tree.DependencyTreePanelKt;
import org.jetbrains.security.toolwindow.tree.VulnerableDependenciesTreeStructure;
import org.jetbrains.security.toolwindow.tree.actions.FindUsagesActionKt;
import org.jetbrains.security.toolwindow.tree.nodes.DependencyNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010)\u001a\u00020\u000eH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0019H\u0016J\u001a\u0010-\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00172\u0006\u0010.\u001a\u00020\u0019H\u0003J\u001c\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00192\b\u00100\u001a\u0004\u0018\u000101H\u0002J\b\u00102\u001a\u00020\u000eH\u0016R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u00178\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/security/toolwindow/tree/DependencyTreePanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/security/toolwindow/ProjectDependencyView;", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "treeStructure", "Lorg/jetbrains/security/toolwindow/tree/VulnerableDependenciesTreeStructure;", "showSafeCheckbox", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "updateChannel", "Lkotlinx/coroutines/channels/Channel;", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/security/toolwindow/tree/VulnerableDependenciesTreeStructure;Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/channels/Channel;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "job", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "popupGroupId", "", "Lorg/jetbrains/annotations/Nls;", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectedPackage", "Lorg/jetbrains/security/package/Package;", "getSelectedPackage", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getShowSafeCheckbox", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "treeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "Lcom/intellij/ui/treeStructure/filtered/FilteringTreeStructure;", "dispose", "getData", "", "dataId", "getFailedToEmitMessage", "packageCoordinates", "getSlowData", "selected", "Lcom/intellij/ui/treeStructure/SimpleNode;", "vulnerabilityUpdate", "intellij.packageChecker"})
public final class DependencyTreePanel
extends SimpleToolWindowPanel
implements Disposable,
ProjectDependencyView,
CoroutineScope {
    @NotNull
    private final Project project;
    @NotNull
    private final VulnerableDependenciesTreeStructure treeStructure;
    @NotNull
    private final MutableStateFlow<Boolean> showSafeCheckbox;
    @NotNull
    private final Channel<Unit> updateChannel;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineContext job;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final MutableStateFlow<Package> selectedPackage;
    @NotNull
    private final StructureTreeModel<FilteringTreeStructure> treeModel;
    @NotNull
    private final SimpleTree tree;
    @NotNull
    private final DefaultTreeExpander treeExpander;
    @NlsSafe
    @NotNull
    private final String popupGroupId;

    public DependencyTreePanel(@NotNull Project project, @NotNull VulnerableDependenciesTreeStructure treeStructure, @NotNull MutableStateFlow<Boolean> showSafeCheckbox, @NotNull Channel<Unit> updateChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)treeStructure), (String)"treeStructure");
        Intrinsics.checkNotNullParameter(showSafeCheckbox, (String)"showSafeCheckbox");
        Intrinsics.checkNotNullParameter(updateChannel, (String)"updateChannel");
        super(false);
        this.project = project;
        this.treeStructure = treeStructure;
        this.showSafeCheckbox = showSafeCheckbox;
        this.updateChannel = updateChannel;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(this::class.java)");
        this.logger = logger;
        this.coroutineContext = this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)new CoroutineName("Package-Checker.DependencyTreePanel"));
        this.selectedPackage = StateFlowKt.MutableStateFlow(null);
        this.treeModel = new StructureTreeModel((AbstractTreeStructure)this.treeStructure, (Disposable)this);
        this.tree = new SimpleTree((TreeModel)new AsyncTreeModel((TreeModel)this.treeModel, (Disposable)this));
        this.treeExpander = new DefaultTreeExpander((JTree)this.tree);
        String string = PackageCheckerBundle.message("dependency.tree.popup.groupid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dependency.tree.popup.groupid\")");
        this.popupGroupId = string;
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(JBUI.scale((int)24));
        EditSourceOnDoubleClickHandler.install$default((JTree)((JTree)this.tree), null, (int)2, null);
        EditSourceOnEnterKeyHandler.install((JTree)((JTree)this.tree));
        this.tree.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)FlowKt.debounce((Flow)FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.updateChannel)), (long)100L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ApplicationManager.getApplication().assertIsNonDispatchThread();
                        this.this$0.treeStructure.rebuild();
                        this.this$0.treeStructure.refilter();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ApplicationManager.getApplication().assertIsDispatchThread();
                        this.this$0.treeModel.invalidateAsync();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getMain())), (Function3)((Function3)new Function3<FlowCollector<? super Unit>, Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        this.this$0.logger.info(it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Unit> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this);
        FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)((Flow)this.getShowSafeCheckbox()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.treeModel.invalidateAsync();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getMain())), (CoroutineScope)this);
        this.tree.addTreeSelectionListener(arg_0 -> DependencyTreePanel._init_$lambda$1(this, arg_0));
        Disposer.register((Disposable)PackageCheckerViewService.Companion.getInstance(this.project), (Disposable)this);
        JComponent jComponent = this.getComponent();
        if (jComponent != null) {
            jComponent.add((Component)this.tree);
        }
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.tree), (String)this.popupGroupId, (String)"ToolwindowContent");
        this.vulnerabilityUpdate();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public MutableStateFlow<Boolean> getShowSafeCheckbox() {
        return this.showSafeCheckbox;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @NotNull
    public MutableStateFlow<Package> getSelectedPackage() {
        return this.selectedPackage;
    }

    @NlsSafe
    private final String getFailedToEmitMessage(String packageCoordinates) {
        Object[] objectArray = new Object[]{packageCoordinates};
        String string = PackageCheckerBundle.message("dependency.tree.failed.to.emit.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dependency.tree\u2026age\", packageCoordinates)");
        return string;
    }

    public void dispose() {
        JobKt.cancel$default((CoroutineContext)this.job, null, (int)1, null);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (DependencyTreePanelKt.getDEPENDENCY_VIEW_HOLDER().is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.treeExpander;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project;
        }
        if (FindUsagesActionKt.getPKGS_LIST().is(dataId)) {
            Object[] objectArray = this.tree.getSelectedNodes(DefaultMutableTreeNode.class, arg_0 -> DependencyTreePanel.getData$lambda$2(getData.selectedNodes.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"tree.getSelectedNodes(De\u2026ncyNode\n                }");
            Object[] selectedNodes2 = (DefaultMutableTreeNode[])objectArray;
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])selectedNodes2), (Function1)getData.1.INSTANCE));
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            SimpleNode selected = this.tree.getSelectedNode();
            return arg_0 -> DependencyTreePanel.getData$lambda$3(this, selected, arg_0);
        }
        return super.getData(dataId);
    }

    private final Object getSlowData(String dataId, SimpleNode selected) {
        FilteringTreeStructure.FilteringNode filteringNode = selected instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)selected : null;
        Object object = filteringNode != null ? filteringNode.getDelegate() : null;
        Object object2 = object instanceof DataContext ? (DataContext)object : null;
        if (object2 == null || (object2 = object2.getData(dataId)) == null) {
            object2 = super.getData(dataId);
        }
        return object2;
    }

    @Override
    public void vulnerabilityUpdate() {
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DependencyTreePanel.access$getUpdateChannel$p(this.this$0).send((Object)Unit.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void _init_$lambda$1(DependencyTreePanel this$0, TreeSelectionEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SimpleNode simpleNode = this$0.tree.getSelectedNode();
            FilteringTreeStructure.FilteringNode filteringNode = simpleNode instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)simpleNode : null;
            Object object = filteringNode != null ? filteringNode.getDelegate() : null;
            DependencyNode dependencyNode = object instanceof DependencyNode ? (DependencyNode)((Object)object) : null;
            if (dependencyNode == null) break block0;
            DependencyNode dependencyNode2 = dependencyNode;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dependencyNode2, this$0, null){
                int label;
                final /* synthetic */ DependencyNode $dependencyNode;
                final /* synthetic */ DependencyTreePanel this$0;
                {
                    this.$dependencyNode = $dependencyNode;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Package packageFromDependency = this.$dependencyNode.getDependency().getPkg();
                            boolean bl = this.this$0.getSelectedPackage().tryEmit((Object)packageFromDependency);
                            DependencyTreePanel dependencyTreePanel = this.this$0;
                            boolean it = bl;
                            boolean bl2 = false;
                            if (!it) {
                                DependencyTreePanel.access$getLogger$p(dependencyTreePanel).warn(DependencyTreePanel.access$getFailedToEmitMessage(dependencyTreePanel, packageFromDependency.getHumanReadableCoordinates()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final boolean getData$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object getData$lambda$3(DependencyTreePanel this$0, SimpleNode $selected, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getSlowData(it, $selected);
    }

    public static final /* synthetic */ Channel access$getUpdateChannel$p(DependencyTreePanel $this) {
        return $this.updateChannel;
    }

    public static final /* synthetic */ String access$getFailedToEmitMessage(DependencyTreePanel $this, String packageCoordinates) {
        return $this.getFailedToEmitMessage(packageCoordinates);
    }
}

