/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.patterns.Substrings;
import org.languagetool.tools.InterruptibleCharSequence;

public abstract class StringMatcher {
    final String pattern;
    final boolean caseSensitive;
    final boolean isRegExp;
    public static final int MAX_MATCH_LENGTH = 250;

    private StringMatcher(String pattern, boolean isRegExp, boolean caseSensitive) {
        this.pattern = pattern;
        this.caseSensitive = caseSensitive;
        this.isRegExp = isRegExp;
    }

    @Nullable
    public abstract Set<String> getPossibleValues();

    public abstract boolean matches(String var1);

    public static StringMatcher regexp(String pattern) {
        return StringMatcher.create(pattern, true, true);
    }

    public static StringMatcher create(String pattern, boolean isRegExp, boolean caseSensitive) {
        return StringMatcher.create(pattern, isRegExp, caseSensitive, Function.identity());
    }

    static StringMatcher create(String pattern, boolean isRegExp, boolean caseSensitive, Function<String, String> internString) {
        if (!isRegExp || "\\0".equals(pattern)) {
            return StringMatcher.stringEquals(pattern, isRegExp, caseSensitive);
        }
        final Pattern compiled = Pattern.compile(pattern, caseSensitive ? 0 : 66);
        Set<String> possibleRegexpValues = StringMatcher.getPossibleRegexpValues(pattern);
        if (possibleRegexpValues != null) {
            final Set<String> set = possibleRegexpValues.stream().map(internString).collect(Collectors.toSet());
            if (set.size() == 1) {
                return StringMatcher.stringEquals((String)set.iterator().next(), true, caseSensitive);
            }
            if (!caseSensitive) {
                final String[] sorted = set.toArray(new String[0]);
                Arrays.sort(sorted, String.CASE_INSENSITIVE_ORDER);
                return new StringMatcher(pattern, true, false){

                    @Override
                    public Set<String> getPossibleValues() {
                        return Sets.newHashSet((Object[])sorted);
                    }

                    @Override
                    public boolean matches(String s) {
                        if (s.length() > 250) {
                            return false;
                        }
                        return Arrays.binarySearch(sorted, s, String.CASE_INSENSITIVE_ORDER) >= 0;
                    }
                };
            }
            return new StringMatcher(pattern, true, true){

                @Override
                public Set<String> getPossibleValues() {
                    return Collections.unmodifiableSet(set);
                }

                @Override
                public boolean matches(String s) {
                    if (s.length() > 250) {
                        return false;
                    }
                    return set.contains(s);
                }
            };
        }
        Substrings required = StringMatcher.getRequiredSubstrings(pattern);
        Substrings exhaustive = required == null ? null : required.checkCanReplaceRegex(pattern);
        final boolean substringsAreSufficient = exhaustive != null;
        final Substrings substrings = substringsAreSufficient ? exhaustive : required;
        return new StringMatcher(pattern, true, caseSensitive){

            @Override
            @Nullable
            public Set<String> getPossibleValues() {
                return null;
            }

            @Override
            public boolean matches(String s) {
                if (s.length() > 250) {
                    return false;
                }
                if (substrings != null && !substrings.matches(s, this.caseSensitive)) {
                    return false;
                }
                if (substringsAreSufficient) {
                    return true;
                }
                return compiled.matcher(new InterruptibleCharSequence(s)).matches();
            }
        };
    }

    @NotNull
    private static StringMatcher stringEquals(String pattern, boolean isRegExp, boolean caseSensitive) {
        return new StringMatcher(pattern, isRegExp, caseSensitive){

            @Override
            public Set<String> getPossibleValues() {
                return Collections.singleton(this.pattern);
            }

            @Override
            public boolean matches(String s) {
                if (s.length() > 250) {
                    return false;
                }
                return this.caseSensitive ? s.equals(this.pattern) : s.equalsIgnoreCase(this.pattern);
            }
        };
    }

    @Nullable
    static Substrings getRequiredSubstrings(String regexp) {
        final Substrings UNKNOWN = new Substrings(false, false, new String[0]);
        RegexpParser<Substrings> parser = new RegexpParser<Substrings>(regexp){

            @Override
            Substrings handleConcatenation(Substrings left, Substrings right) {
                return left.concat(right);
            }

            @Override
            Substrings handleOr(List<Substrings> components) {
                return UNKNOWN;
            }

            @Override
            protected Substrings optional(Substrings groupResults, char op) {
                return UNKNOWN;
            }

            @Override
            protected Substrings unknown() {
                return UNKNOWN;
            }

            @Override
            protected Substrings literal(String literal) {
                return new Substrings(true, true, new String[]{literal});
            }
        };
        try {
            Substrings result2 = (Substrings)parser.disjunction();
            return result2.substrings.length == 0 ? null : result2;
        }
        catch (TooComplexRegexp e) {
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    static Set<String> getPossibleRegexpValues(String regexp) {
        RegexpParser<Stream<String>> parser = new RegexpParser<Stream<String>>(regexp){

            @Override
            Stream<String> handleConcatenation(Stream<String> left, Stream<String> right) {
                List groupResults = right.collect(Collectors.toList());
                return left.flatMap(s1 -> groupResults.stream().map(s2 -> s1 + s2));
            }

            @Override
            Stream<String> handleOr(List<Stream<String>> components) {
                return components.stream().flatMap(Function.identity());
            }

            @Override
            protected Stream<String> optional(Stream<String> groupResults, char op) {
                return op == '?' ? Stream.concat(Stream.of(""), groupResults) : this.unknown();
            }

            @Override
            protected Stream<String> unknown() {
                throw TooComplexRegexp.INSTANCE;
            }

            @Override
            protected Stream<String> literal(String literal) {
                return Stream.of(literal);
            }
        };
        try {
            return ((Stream)parser.disjunction()).collect(Collectors.toSet());
        }
        catch (TooComplexRegexp e) {
            return null;
        }
    }

    private static class TooComplexRegexp
    extends RuntimeException {
        private static final TooComplexRegexp INSTANCE = new TooComplexRegexp();

        private TooComplexRegexp() {
        }
    }

    private static abstract class RegexpParser<T> {
        private static final String unsupported = "?$^{}*+";
        private static final String finishing = ")|";
        private static final String starting = "([\\";
        private static final String nonLiteral = ")|?$^{}*+([\\.";
        private final String regexp;
        private int pos;

        RegexpParser(String regexp) {
            if (regexp.startsWith("\\b")) {
                regexp = regexp.substring(2);
            }
            if (regexp.startsWith("^")) {
                regexp = regexp.substring(1);
            }
            if (regexp.endsWith("\\b") && !regexp.endsWith("\\\\b")) {
                regexp = regexp.substring(0, regexp.length() - 2);
            }
            if (regexp.endsWith("$") && !regexp.endsWith("\\$")) {
                regexp = regexp.substring(0, regexp.length() - 1);
            }
            this.regexp = regexp;
        }

        T disjunction() {
            ArrayList<T> components = new ArrayList<T>();
            components.add(this.concatenation());
            while (this.pos < this.regexp.length() && this.regexp.charAt(this.pos) == '|') {
                ++this.pos;
                components.add(this.concatenation());
            }
            return (T)(components.size() == 1 ? components.get(0) : this.handleOr(components));
        }

        abstract T handleOr(List<T> var1);

        abstract T handleConcatenation(T var1, T var2);

        protected abstract T optional(T var1, char var2);

        protected abstract T literal(String var1);

        protected abstract T unknown();

        private T concatenation() {
            char c;
            T result2 = this.postfix();
            while (this.pos < this.regexp.length() && finishing.indexOf(c = this.regexp.charAt(this.pos)) < 0) {
                if (unsupported.indexOf(c) >= 0) {
                    throw TooComplexRegexp.INSTANCE;
                }
                result2 = this.handleConcatenation(result2, this.postfix());
            }
            return result2;
        }

        private T postfix() {
            T groupResults = this.atom();
            if (this.pos < this.regexp.length()) {
                char next = this.regexp.charAt(this.pos);
                if (next == '{') {
                    int closing = this.regexp.indexOf(125, this.pos + 1);
                    if (closing < 0) {
                        throw new AssertionError((Object)("Closing } expected after " + this.pos));
                    }
                    this.pos = closing + 1;
                    groupResults = this.unknown();
                    if (this.pos >= this.regexp.length()) {
                        return groupResults;
                    }
                    next = this.regexp.charAt(this.pos);
                }
                if ("*+?".indexOf(next) >= 0) {
                    ++this.pos;
                    return this.optional(groupResults, next);
                }
            }
            return groupResults;
        }

        private T atom() {
            if (this.pos >= this.regexp.length()) {
                return this.literal("");
            }
            switch (this.regexp.charAt(this.pos)) {
                case '(': {
                    if (this.regexp.charAt(++this.pos) == '?') {
                        if (this.regexp.charAt(++this.pos) != ':') {
                            throw TooComplexRegexp.INSTANCE;
                        }
                        ++this.pos;
                    }
                    T group = this.disjunction();
                    if (this.regexp.charAt(this.pos++) != ')') {
                        throw TooComplexRegexp.INSTANCE;
                    }
                    return group;
                }
                case '[': {
                    return this.squareBracketGroup();
                }
                case '\\': {
                    ++this.pos;
                    return this.charLiteral(this.escape());
                }
                case '.': {
                    ++this.pos;
                    return this.unknown();
                }
            }
            int literalStart = this.pos;
            while (this.pos < this.regexp.length() && nonLiteral.indexOf(this.regexp.charAt(this.pos)) < 0) {
                ++this.pos;
            }
            if (literalStart + 1 < this.pos && this.pos < this.regexp.length() && this.regexp.charAt(this.pos) == '?') {
                --this.pos;
            }
            return this.literal(this.regexp.substring(literalStart, this.pos));
        }

        private T squareBracketGroup() {
            char c1;
            int start = ++this.pos;
            ArrayList<Character> options = new ArrayList<Character>();
            while ((c1 = this.regexp.charAt(this.pos++)) != ']') {
                Character simpleChar;
                if (c1 == '-' && this.pos != start + 1 && this.regexp.charAt(this.pos) != ']') {
                    Character last = options == null ? null : (Character)options.get(options.size() - 1);
                    char next = this.regexp.charAt(this.pos++);
                    if (last == null || next == '\\' || next - last.charValue() > 10) {
                        options = null;
                    }
                    if (options == null) continue;
                    for (int c2 = last.charValue() + '\u0001'; c2 <= next; ++c2) {
                        options.add(Character.valueOf((char)c2));
                    }
                    continue;
                }
                if (c1 == '^') {
                    options = null;
                    continue;
                }
                if (c1 == '[') {
                    throw TooComplexRegexp.INSTANCE;
                }
                Character c3 = simpleChar = c1 == '\\' ? this.escape() : Character.valueOf(c1);
                if (options == null) continue;
                options.add(simpleChar);
            }
            if (options == null) {
                return this.unknown();
            }
            List components = options.stream().map(c -> this.charLiteral((Character)c)).collect(Collectors.toList());
            if (components.isEmpty()) {
                throw TooComplexRegexp.INSTANCE;
            }
            return components.size() == 1 ? components.get(0) : this.handleOr(components);
        }

        private T charLiteral(@Nullable Character c) {
            return c == null ? this.unknown() : this.literal(String.valueOf(c));
        }

        @Nullable
        private Character escape() {
            char next;
            if ("0xucpP".indexOf(next = this.regexp.charAt(this.pos++)) >= 0) {
                throw TooComplexRegexp.INSTANCE;
            }
            if (Character.isLetterOrDigit(next)) {
                return null;
            }
            return Character.valueOf(next);
        }
    }
}

