/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.core.util.TermSize;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalBlocksComponent;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalContentController;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "blocksComponent", "Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksComponent;", "commandFinished", "", "command", "", "exitCode", "", "duration", "", "commandStarted", "dispose", "finishCommandBlock", "removeIfEmpty", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "getTerminalSize", "Lcom/jediterm/core/util/TermSize;", "initialized", "isFocused", "startCommandExecution", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalBlocksController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksController.kt\norg/jetbrains/plugins/terminal/exp/TerminalBlocksController\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n251#2,7:104\n251#2,7:112\n8#3:111\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksController.kt\norg/jetbrains/plugins/terminal/exp/TerminalBlocksController\n*L\n80#1:104,7\n51#1:112,7\n50#1:111\n*E\n"})
public final class TerminalBlocksController
implements TerminalContentController,
TerminalCommandExecutor,
ShellCommandListener {
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final TerminalBlocksComponent blocksComponent;

    public TerminalBlocksController(@NotNull Project project, @NotNull TerminalSession session, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.session = session;
        this.blocksComponent = new TerminalBlocksComponent(project, this.session, settings, this, (Disposable)this);
        this.blocksComponent.installRunningPanel();
        this.blocksComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                TermSize termSize = this.getTerminalSize();
                if (termSize == null) {
                    return;
                }
                TermSize newSize = termSize;
                session.postResize(newSize);
            }
        });
        TerminalSession.addCommandListener$default(this.session, this, null, 2, null);
        TerminalModel.addTerminalListener$default(this.session.getModel(), new TerminalModel.TerminalListener(){

            @Override
            public void onAlternateBufferChanged(boolean enabled) {
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, enabled){
                    final /* synthetic */ TerminalBlocksController this$0;
                    final /* synthetic */ boolean $enabled;
                    {
                        this.this$0 = $receiver;
                        this.$enabled = $enabled;
                        super(0);
                    }

                    public final void invoke() {
                        TerminalBlocksController.access$getBlocksComponent$p(this.this$0).toggleFullScreen(this.$enabled);
                    }
                }), (int)1, null);
            }
        }, null, 2, null);
    }

    @Override
    public void startCommandExecution(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        ApplicationManager.getApplication().executeOnPooledThread(() -> TerminalBlocksController.startCommandExecution$lambda$1(this, command));
    }

    @Override
    public void initialized() {
        this.finishCommandBlock(true);
    }

    @Override
    public void commandStarted(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.session.getModel().setCommandRunning(true);
    }

    @Override
    public void commandFinished(@NotNull String command, int exitCode, long duration) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.finishCommandBlock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommandBlock(boolean removeIfEmpty) {
        this.blocksComponent.makeCurrentBlockReadOnly(removeIfEmpty);
        TerminalModel model = this.session.getModel();
        model.setCommandRunning(false);
        TerminalModel this_$iv = model;
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            TerminalModel.clearAllExceptPrompt$default(model, 0, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
        model.getCommandExecutionSemaphore().up();
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalBlocksController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TerminalBlocksController.access$getBlocksComponent$p(this.this$0).resetPromptPanel();
            }
        }), (int)1, null);
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        return this.blocksComponent.getTerminalSize();
    }

    @Override
    public boolean isFocused() {
        return this.blocksComponent.isFocused();
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return this.blocksComponent;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.blocksComponent.getPreferredFocusableComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void startCommandExecution$lambda$1(TerminalBlocksController this$0, String $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        TerminalModel model = this$0.session.getModel();
        if (model.getCommandExecutionSemaphore().waitFor(3000L)) {
            model.getCommandExecutionSemaphore().down();
        } else {
            String string;
            void this_$iv;
            Object $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalBlocksController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            $this$thisLogger$iv = model;
            String string2 = $command;
            Logger logger2 = logger;
            boolean $i$f$withContentLock = false;
            this_$iv.lockContent();
            try {
                boolean bl = false;
                string = TerminalModel.getAllText$default(model, 0, 0, 3, null);
            }
            finally {
                this_$iv.unlockContent();
            }
            String string3 = string;
            logger2.error("Failed to acquire the command execution lock to execute command: '" + string2 + "'\nText buffer:\n" + string3);
        }
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this$0, $command){
            final /* synthetic */ TerminalBlocksController this$0;
            final /* synthetic */ String $command;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                super(0);
            }

            public final void invoke() {
                TerminalBlocksController.access$getBlocksComponent$p(this.this$0).installRunningPanel();
                TerminalBlocksController.access$getSession$p(this.this$0).executeCommand(this.$command);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ TerminalBlocksComponent access$getBlocksComponent$p(TerminalBlocksController $this) {
        return $this.blocksComponent;
    }
}

