/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.CellBorderComponentsKt;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/SausageBorder;", "Ljavax/swing/border/AbstractBorder;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "", "y", "initialWidth", "initialHeight", "intellij.notebooks.ui"})
final class SausageBorder
extends AbstractBorder {
    @NotNull
    private final Editor editor;

    public SausageBorder(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        JBInsets jBInsets = JBUI.insetsBottom((int)(1 - c.getHeight() % 2));
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsBottom(1 - c.height % 2)");
        return (Insets)jBInsets;
    }

    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int initialWidth, int initialHeight) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance(this.editor);
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(notebookEditorAppearance.getSausageButtonBorderColor(editorColorsScheme));
        int width = initialWidth - 1;
        int height = initialHeight - 1;
        Container container = c.getParent();
        Component[] components = container != null ? container.getComponents() : null;
        JButton leftButton = CellBorderComponentsKt.access$getLeftButton(components);
        JButton rightButton = CellBorderComponentsKt.access$getRightButton(components);
        int radius = height / 2;
        if (components == null || components.length <= 1) {
            g.drawRoundRect(x, y, width, height, height, height);
        } else if (leftButton == c) {
            g.drawLine(x + radius, y, x + width, y);
            g.drawLine(x + width + radius, y, x + width, y + height);
            g.drawLine(x + radius, y + height, x + width, y + height);
            g.drawArc(x, y, height, height, 90, 180);
        } else if (rightButton == c) {
            g.drawLine(x, y, x + width - radius, y);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x, y + height, x + width - radius, y + height);
            g.drawArc(x + width - height, y, height, height, -90, 180);
        } else {
            g.drawRect(x, y, width + height, height);
        }
    }
}

