/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.thoughtworks.qdox.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.DocletTag;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.IndentBuffer;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaClass;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaSource;

public abstract class AbstractJavaEntity
extends AbstractBaseJavaEntity
implements Comparable {
    protected List modifiers = new ArrayList();
    private String comment;
    private DocletTag[] tags = new DocletTag[0];
    private JavaClass parentClass;

    public String[] getModifiers() {
        return this.modifiers.toArray(new String[this.modifiers.size()]);
    }

    public String getComment() {
        return this.comment;
    }

    public DocletTag[] getTags() {
        return this.tags;
    }

    public DocletTag[] getTagsByName(String name) {
        ArrayList<DocletTag> specifiedTags = new ArrayList<DocletTag>();
        for (int i = 0; i < this.tags.length; ++i) {
            DocletTag docletTag = this.tags[i];
            if (!docletTag.getName().equals(name)) continue;
            specifiedTags.add(docletTag);
        }
        return specifiedTags.toArray(new DocletTag[specifiedTags.size()]);
    }

    public DocletTag getTagByName(String name) {
        for (int i = 0; i < this.tags.length; ++i) {
            DocletTag docletTag = this.tags[i];
            if (!docletTag.getName().equals(name)) continue;
            return docletTag;
        }
        return null;
    }

    public String getNamedParameter(String tagName, String parameterName) {
        DocletTag tag = this.getTagByName(tagName);
        if (tag != null) {
            return tag.getNamedParameter(parameterName);
        }
        return null;
    }

    void commentHeader(IndentBuffer buffer) {
        if (this.comment == null && (this.tags == null || this.tags.length == 0)) {
            return;
        }
        buffer.write("/**");
        buffer.newline();
        if (this.comment != null && this.comment.length() > 0) {
            buffer.write(" * ");
            buffer.write(this.comment.replaceAll("\n", "\n * "));
            buffer.newline();
        }
        if (this.tags != null && this.tags.length > 0) {
            if (this.comment != null && this.comment.length() > 0) {
                buffer.write(" *");
                buffer.newline();
            }
            for (int i = 0; i < this.tags.length; ++i) {
                DocletTag docletTag = this.tags[i];
                buffer.write(" * @");
                buffer.write(docletTag.getName());
                if (docletTag.getValue().length() > 0) {
                    buffer.write(' ');
                    buffer.write(docletTag.getValue());
                }
                buffer.newline();
            }
        }
        buffer.write(" */");
        buffer.newline();
    }

    public String getCodeBlock() {
        IndentBuffer result = new IndentBuffer();
        this.write(result);
        return result.toString();
    }

    protected void write(IndentBuffer result) {
        this.commentHeader(result);
        this.writeBody(result);
    }

    protected abstract void writeBody(IndentBuffer var1);

    public void setModifiers(String[] modifiers) {
        this.modifiers = Arrays.asList(modifiers);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTags(List tagList) {
        this.tags = new DocletTag[tagList.size()];
        tagList.toArray(this.tags);
    }

    public boolean isAbstract() {
        return this.isModifierPresent("abstract");
    }

    public boolean isPublic() {
        return this.isModifierPresent("public");
    }

    public boolean isPrivate() {
        return this.isModifierPresent("private");
    }

    public boolean isProtected() {
        return this.isModifierPresent("protected");
    }

    public boolean isStatic() {
        return this.isModifierPresent("static");
    }

    public boolean isFinal() {
        return this.isModifierPresent("final");
    }

    public boolean isSynchronized() {
        return this.isModifierPresent("synchronized");
    }

    public boolean isTransient() {
        return this.isModifierPresent("transient");
    }

    public boolean isVolatile() {
        return this.isModifierPresent("volatile");
    }

    public boolean isNative() {
        return this.isModifierPresent("native");
    }

    public boolean isStrictfp() {
        return this.isModifierPresent("strictfp");
    }

    private boolean isModifierPresent(String modifier) {
        return this.modifiers.contains(modifier);
    }

    protected void writeNonAccessibilityModifiers(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            if (modifier.startsWith("p")) continue;
            result.write(modifier);
            result.write(' ');
        }
    }

    protected void writeAccessibilityModifier(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            if (!modifier.startsWith("p")) continue;
            result.write(modifier);
            result.write(' ');
        }
    }

    protected void writeAllModifiers(IndentBuffer result) {
        Iterator iter = this.modifiers.iterator();
        while (iter.hasNext()) {
            String modifier = (String)iter.next();
            result.write(modifier);
            result.write(' ');
        }
    }

    public JavaSource getSource() {
        return this.parentClass.getParentSource();
    }

    public void setParentClass(JavaClass parentClass) {
        this.parentClass = parentClass;
    }

    public JavaClass getParentClass() {
        return this.parentClass;
    }
}

