/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.version;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.plugins.IvySettingsAware;
import org.gradle.internal.impldep.org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.gradle.internal.impldep.org.apache.ivy.plugins.version.VersionMatcher;
import org.gradle.internal.impldep.org.apache.ivy.util.Checks;

public class ChainVersionMatcher
extends AbstractVersionMatcher {
    private List matchers = new LinkedList();

    public ChainVersionMatcher() {
        super("chain");
    }

    public void add(VersionMatcher matcher) {
        Checks.checkNotNull(matcher, "matcher");
        this.matchers.add(0, matcher);
        if (this.getSettings() != null && matcher instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)matcher)).setSettings(this.getSettings());
        }
    }

    public void setSettings(IvySettings settings) {
        super.setSettings(settings);
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (!(matcher instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)matcher)).setSettings(settings);
        }
    }

    public List getMatchers() {
        return Collections.unmodifiableList(this.matchers);
    }

    public boolean isDynamic(ModuleRevisionId askedMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (!matcher.isDynamic(askedMrid)) continue;
            return true;
        }
        return false;
    }

    public int compare(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid, Comparator staticComparator) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Checks.checkNotNull(staticComparator, "staticComparator");
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (!matcher.isDynamic(askedMrid)) continue;
            return matcher.compare(askedMrid, foundMrid, staticComparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + askedMrid);
    }

    public boolean accept(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.accept(askedMrid, foundMrid);
        }
        return false;
    }

    public boolean needModuleDescriptor(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.needModuleDescriptor(askedMrid, foundMrid);
        }
        return false;
    }

    public boolean accept(ModuleRevisionId askedMrid, ModuleDescriptor foundMD) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMD, "foundMD");
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = (VersionMatcher)iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.accept(askedMrid, foundMD);
        }
        return false;
    }
}

