/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import org.gradle.internal.impldep.org.junit.platform.commons.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.launcher.Launcher;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherSession;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherSessionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;

class DefaultLauncherSession
implements LauncherSession {
    private final DelegatingLauncher launcher;
    private final LauncherSessionListener listener;

    DefaultLauncherSession(Launcher launcher, LauncherSessionListener listener) {
        this.launcher = new DelegatingLauncher(launcher);
        this.listener = listener;
        listener.launcherSessionOpened(this);
    }

    @Override
    public Launcher getLauncher() {
        return this.launcher;
    }

    LauncherSessionListener getListener() {
        return this.listener;
    }

    @Override
    public void close() {
        if (this.launcher.getDelegate() != ClosedLauncher.INSTANCE) {
            this.launcher.setDelegate(ClosedLauncher.INSTANCE);
            this.listener.launcherSessionClosed(this);
        }
    }

    private static class DelegatingLauncher
    implements Launcher {
        private Launcher delegate;

        DelegatingLauncher(Launcher delegate) {
            this.delegate = delegate;
        }

        public Launcher getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Launcher delegate) {
            this.delegate = delegate;
        }

        @Override
        public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
            this.delegate.registerLauncherDiscoveryListeners(listeners);
        }

        @Override
        public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
            this.delegate.registerTestExecutionListeners(listeners);
        }

        @Override
        public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
            return this.delegate.discover(launcherDiscoveryRequest);
        }

        @Override
        public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... listeners) {
            this.delegate.execute(launcherDiscoveryRequest, listeners);
        }

        @Override
        public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
            this.delegate.execute(testPlan, listeners);
        }
    }

    private static class ClosedLauncher
    implements Launcher {
        static final ClosedLauncher INSTANCE = new ClosedLauncher();

        private ClosedLauncher() {
        }

        @Override
        public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }
    }
}

