/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.Disposed;
import com.intellij.profiler.api.Inactive;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.Terminated;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 C*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001CB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007JD\u0010.\u001a\u00020)2:\u0010/\u001a6\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*H\u0016J\u0010\u00100\u001a\u00020)2\u0006\u0010(\u001a\u00020\u0016H\u0004J\b\u00101\u001a\u00020)H\u0016J\b\u00102\u001a\u00020\u001eH\u0014J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0004J\u0010\u00106\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020)H$J\b\u00108\u001a\u00020)H\u0014JD\u00109\u001a\u00020)2:\u0010/\u001a6\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*H\u0016J\u001c\u0010:\u001a\u00020)2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020)0<H\u0004J\u0010\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u0011H\u0007J\b\u0010@\u001a\u00020)H\u0016J\b\u0010A\u001a\u00020\u001eH\u0016J\b\u0010B\u001a\u00020\u001eH\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!RH\u0010\"\u001a<\u00128\u00126\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)0$j\u0002`*0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,\u00a8\u0006D"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/api/ProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "dumpReadIndicator", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "getDumpReadIndicator", "()Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "eventsBroadcaster", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "myState", "Lcom/intellij/profiler/api/ProfilerState;", "pendingEvents", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/ProfilerProcessBase$Companion$StateTransition;", "Lkotlin/collections/ArrayList;", "getProject", "()Lcom/intellij/openapi/project/Project;", "startNotified", "", "state", "getState", "()Lcom/intellij/profiler/api/ProfilerState;", "stateChangedListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "oldState", "newState", "", "Lcom/intellij/profiler/api/OnStateChangedCallback;", "getTargetProcess", "()Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "addStateChangedListener", "listener", "changeStateAndNotifyAsync", "dispose", "doStop", "initTargetProcessLifecycleListener", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "notifyListeners", "onTargetProcessTerminated", "onTerminateCalled", "removeStateChangedListener", "runUnderDumpReadIndicator", "process", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setEventsBroadcastingExecutorService", "executorService", "startNotify", "stop", "terminate", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProcessBase.kt\ncom/intellij/profiler/ProfilerProcessBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1855#2,2:145\n*S KotlinDebug\n*F\n+ 1 ProfilerProcessBase.kt\ncom/intellij/profiler/ProfilerProcessBase\n*L\n133#1:145,2\n*E\n"})
public abstract class ProfilerProcessBase<TargetProcess extends ProfilerTargetProcess>
implements ProfilerProcess<TargetProcess> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TargetProcess targetProcess;
    @NotNull
    private ExecutorService eventsBroadcaster;
    @NotNull
    private ArrayList<Companion.StateTransition> pendingEvents;
    private boolean startNotified;
    @NotNull
    private ProfilerState myState;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final ProgressIndicatorBase dumpReadIndicator;
    @NotNull
    private final CopyOnWriteArrayList<Function2<ProfilerState, ProfilerState, Unit>> stateChangedListeners;

    public ProfilerProcessBase(@NotNull Project project, @NotNull TargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        this.project = project;
        this.targetProcess = targetProcess;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProfilerProcessEventsBroadcaster");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicat\u2026rocessEventsBroadcaster\")");
        this.eventsBroadcaster = executorService;
        this.pendingEvents = new ArrayList();
        this.myState = Inactive.INSTANCE;
        this.lock = new ReentrantLock();
        this.dumpReadIndicator = new ProgressIndicatorBase();
        this.stateChangedListeners = new CopyOnWriteArrayList();
        this.changeStateAndNotifyAsync(Attached.INSTANCE);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @NotNull
    protected final ProgressIndicatorBase getDumpReadIndicator() {
        return this.dumpReadIndicator;
    }

    @Override
    @NotNull
    public ProfilerState getState() {
        return this.myState;
    }

    @NotNull
    protected abstract Logger getLOG();

    protected final void initTargetProcessLifecycleListener(@NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(this){
            final /* synthetic */ ProfilerProcessBase<TargetProcess> this$0;
            {
                this.this$0 = $receiver;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.onTargetProcessTerminated();
            }
        }, (Disposable)this);
    }

    protected final void runUnderDumpReadIndicator(@NotNull Function1<? super ProgressIndicator, Unit> process) {
        Intrinsics.checkNotNullParameter(process, (String)"process");
        Project project = this.getProject();
        String string = CommonProfilerBundleKt.profilerMessage("profiler.state.reading.data", new Object[0]);
        new Task.Backgroundable(process, project, string){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $process;
            {
                this.$process = $process;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$process.invoke((Object)indicator);
            }
        }.queue();
    }

    protected abstract void onTargetProcessTerminated();

    protected boolean doStop() {
        return true;
    }

    @Override
    public boolean stop() {
        if (!this.canBeStopped()) {
            return false;
        }
        if (!this.getLOG().assertTrue(this.getState() == Attached.INSTANCE, (Object)("Profiler is in " + this.getState() + " state. Should be in 'ATTACHED' state."))) {
            return false;
        }
        return this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNotify() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.startNotified) {
                this.getLOG().error("startNotify() was already called");
                return;
            }
            this.startNotified = true;
            this.eventsBroadcaster.submit(() -> ProfilerProcessBase.startNotify$lambda$1$lambda$0(this));
            this.pendingEvents.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeStateAndNotifyAsync(@NotNull ProfilerState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myState instanceof Disposed) {
                return;
            }
            Companion.StateTransition event = new Companion.StateTransition(this.myState, newState);
            this.myState = newState;
            if (this.startNotified) {
                this.eventsBroadcaster.submit(() -> ProfilerProcessBase.changeStateAndNotifyAsync$lambda$3$lambda$2(this, event));
            } else {
                this.pendingEvents.add(event);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addStateChangedListener(@NotNull Function2<? super ProfilerState, ? super ProfilerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.stateChangedListeners.add(listener2);
    }

    @Override
    public void removeStateChangedListener(@NotNull Function2<? super ProfilerState, ? super ProfilerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.stateChangedListeners.remove(listener2);
    }

    @Override
    public boolean terminate() {
        if (!this.getState().isActive()) {
            return false;
        }
        if (!this.dumpReadIndicator.isCanceled()) {
            this.dumpReadIndicator.cancel();
        }
        ApplicationManager.getApplication().executeOnPooledThread(this::onTerminateCalled);
        this.changeStateAndNotifyAsync(Terminated.INSTANCE);
        return true;
    }

    protected void onTerminateCalled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myState instanceof Disposed) {
                return;
            }
            this.myState = Disposed.INSTANCE;
            this.eventsBroadcaster.shutdownNow();
            this.pendingEvents.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.stateChangedListeners.clear();
        if (!this.dumpReadIndicator.isCanceled()) {
            this.dumpReadIndicator.cancel();
        }
    }

    private final void notifyListeners(Companion.StateTransition state) {
        this.getLOG().info("notifyStateChangedAsync: " + state.getOld() + " -> " + state.getNew());
        Iterable $this$forEach$iv = this.stateChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)state.getOld(), (Object)state.getNew());
        }
    }

    @TestOnly
    public final void setEventsBroadcastingExecutorService(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.eventsBroadcaster = executorService;
    }

    private static final void startNotify$lambda$1$lambda$0(ProfilerProcessBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (Companion.StateTransition event : this$0.pendingEvents) {
            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
            this$0.notifyListeners(event);
        }
    }

    private static final void changeStateAndNotifyAsync$lambda$3$lambda$2(ProfilerProcessBase this$0, Companion.StateTransition $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.notifyListeners($event);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase$Companion;", "", "()V", "StateTransition", "intellij.profiler.common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ProfilerProcessBase$Companion$StateTransition;", "", "old", "Lcom/intellij/profiler/api/ProfilerState;", "new", "(Lcom/intellij/profiler/api/ProfilerState;Lcom/intellij/profiler/api/ProfilerState;)V", "getNew", "()Lcom/intellij/profiler/api/ProfilerState;", "getOld", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
        public static final class StateTransition {
            @NotNull
            private final ProfilerState old;
            @NotNull
            private final ProfilerState new;

            public StateTransition(@NotNull ProfilerState old, @NotNull ProfilerState profilerState) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)profilerState, (String)"new");
                this.old = old;
                this.new = profilerState;
            }

            @NotNull
            public final ProfilerState getOld() {
                return this.old;
            }

            @NotNull
            public final ProfilerState getNew() {
                return this.new;
            }

            @NotNull
            public final ProfilerState component1() {
                return this.old;
            }

            @NotNull
            public final ProfilerState component2() {
                return this.new;
            }

            @NotNull
            public final StateTransition copy(@NotNull ProfilerState old, @NotNull ProfilerState profilerState) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)profilerState, (String)"new");
                return new StateTransition(old, profilerState);
            }

            public static /* synthetic */ StateTransition copy$default(StateTransition stateTransition, ProfilerState profilerState, ProfilerState profilerState2, int n, Object object) {
                if ((n & 1) != 0) {
                    profilerState = stateTransition.old;
                }
                if ((n & 2) != 0) {
                    profilerState2 = stateTransition.new;
                }
                return stateTransition.copy(profilerState, profilerState2);
            }

            @NotNull
            public String toString() {
                return "StateTransition(old=" + this.old + ", new=" + this.new + ")";
            }

            public int hashCode() {
                int result2 = this.old.hashCode();
                result2 = result2 * 31 + this.new.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StateTransition)) {
                    return false;
                }
                StateTransition stateTransition = (StateTransition)other;
                if (!Intrinsics.areEqual((Object)this.old, (Object)stateTransition.old)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.new, (Object)stateTransition.new);
            }
        }
    }
}

