/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.profiler.WithUserFriendlyMessage;
import com.intellij.profiler.api.AttachableTargetProcess;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/api/ProfilerAlreadyStartedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lcom/intellij/profiler/WithUserFriendlyMessage;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "(Lcom/intellij/profiler/api/AttachableTargetProcess;)V", "getTargetProcess", "()Lcom/intellij/profiler/api/AttachableTargetProcess;", "userFriendlyMessage", "", "getUserFriendlyMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.profiler.common"})
public final class ProfilerAlreadyStartedException
extends Exception
implements WithUserFriendlyMessage {
    @NotNull
    private final AttachableTargetProcess targetProcess;
    @NotNull
    private final String userFriendlyMessage;

    public ProfilerAlreadyStartedException(@NotNull AttachableTargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        this.targetProcess = targetProcess;
        this.userFriendlyMessage = "Profiler for process '" + this.targetProcess.getFullName() + "' with pid " + this.targetProcess.getPid() + " is already started";
    }

    @NotNull
    public final AttachableTargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @Override
    @NotNull
    public String getUserFriendlyMessage() {
        return this.userFriendlyMessage;
    }

    @NotNull
    public final AttachableTargetProcess component1() {
        return this.targetProcess;
    }

    @NotNull
    public final ProfilerAlreadyStartedException copy(@NotNull AttachableTargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        return new ProfilerAlreadyStartedException(targetProcess);
    }

    public static /* synthetic */ ProfilerAlreadyStartedException copy$default(ProfilerAlreadyStartedException profilerAlreadyStartedException, AttachableTargetProcess attachableTargetProcess, int n, Object object) {
        if ((n & 1) != 0) {
            attachableTargetProcess = profilerAlreadyStartedException.targetProcess;
        }
        return profilerAlreadyStartedException.copy(attachableTargetProcess);
    }

    @Override
    @NotNull
    public String toString() {
        return "ProfilerAlreadyStartedException(targetProcess=" + this.targetProcess + ")";
    }

    public int hashCode() {
        return this.targetProcess.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfilerAlreadyStartedException)) {
            return false;
        }
        ProfilerAlreadyStartedException profilerAlreadyStartedException = (ProfilerAlreadyStartedException)other;
        return Intrinsics.areEqual((Object)this.targetProcess, (Object)profilerAlreadyStartedException.targetProcess);
    }
}

