/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.statistics;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/statistics/FusAwareMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "componentId", "Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;)V", "logPopupInvoked", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "mouseReleased", "intellij.profiler.common"})
public final class FusAwareMouseAdapter
extends MouseAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerTabComponentNameWithId componentId;

    public FusAwareMouseAdapter(@NotNull Project project, @NotNull ProfilerTabComponentNameWithId componentId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        this.project = project;
        this.componentId = componentId;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logPopupInvoked(e);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logPopupInvoked(e);
    }

    private final void logPopupInvoked(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        ProfilerUsageTriggerCollector.Companion.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.Companion, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_CONTEXT_MENU, this.componentId, null, 8, null);
    }
}

