/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.CascadeExpansion;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.treetable.TreeExpandedPaths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/callusage/UsageModelActions;", "", "()V", "fold", "", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "mergePaths", "head", "tail", "unfold", "intellij.profiler.common"})
public final class UsageModelActions {
    @NotNull
    public static final UsageModelActions INSTANCE = new UsageModelActions();

    private UsageModelActions() {
    }

    public final void fold(@NotNull JTree tree, @NotNull TreePath path) {
        TreeExpandedPaths treeExpandedPaths;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        TreeModel treeModel = tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.callusage.MainCallTreeUIModel");
        MainCallTreeUIModel model2 = (MainCallTreeUIModel)((Object)treeModel);
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement>{ com.intellij.profiler.ui.callusage.CallUsageNodeKt.CallUsageNode }");
        CallTreeNode<BaseCallStackElement> foldedNode = model2.getFoldedNode((CallTreeNode)object);
        TreeExpandedPaths $this$fold_u24lambda_u240 = treeExpandedPaths = TreeExpandedPaths.createOn(tree, path);
        boolean bl = false;
        if (tree.isExpanded(path)) {
            TreePath[] treePathArray = new TreePath[]{path};
            $this$fold_u24lambda_u240.with(treePathArray);
        }
        TreeExpandedPaths state = treeExpandedPaths;
        TreePath folded = model2.foldPath(path, foldedNode);
        if (folded != path) {
            List<TreePath> paths = state.updateAny(arg_0 -> UsageModelActions.fold$lambda$1(folded, arg_0)).getPaths();
            if (paths.size() > 0) {
                Intrinsics.checkNotNullExpressionValue(paths, (String)"paths");
                CascadeExpansion.Companion.expandPathsWithoutCascade(tree, (Collection<? extends TreePath>)paths);
            }
            tree.setSelectionPath(folded);
        }
    }

    public final void unfold(@NotNull JTree tree, @NotNull TreePath path) {
        TreeExpandedPaths treeExpandedPaths;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        TreeExpandedPaths $this$unfold_u24lambda_u242 = treeExpandedPaths = TreeExpandedPaths.createOn(tree, path);
        boolean bl = false;
        TreePath treePath = path.getParentPath();
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path.parentPath");
        CascadeExpansion.Companion.expandPathWithoutCascade(tree, treePath);
        TreeExpandedPaths state = treeExpandedPaths;
        TreeModel treeModel = tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.callusage.MainCallTreeUIModel");
        TreePath unfolded = ((MainCallTreeUIModel)((Object)treeModel)).unfoldPath(path);
        if (unfolded != path) {
            List<TreePath> paths = state.updateAny(arg_0 -> UsageModelActions.unfold$lambda$3(unfolded, arg_0)).getPaths();
            if (paths.size() > 0) {
                Intrinsics.checkNotNullExpressionValue(paths, (String)"paths");
                CascadeExpansion.Companion.expandPathsWithoutCascade(tree, (Collection<? extends TreePath>)paths);
            } else {
                TreePath treePath2 = unfolded.getParentPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"unfolded.parentPath");
                CascadeExpansion.Companion.expandPathWithoutCascade(tree, treePath2);
            }
            tree.setSelectionPath(unfolded);
        }
    }

    private final TreePath mergePaths(TreePath head, TreePath tail) {
        TreePath current;
        LinkedList<Object> path = new LinkedList<Object>();
        for (current = head; current != null && !Intrinsics.areEqual((Object)current.getLastPathComponent(), (Object)tail.getLastPathComponent()); current = current.getParentPath()) {
            path.add(0, current.getLastPathComponent());
        }
        if (current == null) {
            path.clear();
        }
        for (current = tail; current != null; current = current.getParentPath()) {
            path.add(0, current.getLastPathComponent());
        }
        return new TreePath(path.toArray());
    }

    private static final TreePath fold$lambda$1(TreePath $folded, TreePath it) {
        Intrinsics.checkNotNullParameter((Object)$folded, (String)"$folded");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return INSTANCE.mergePaths(it, $folded);
    }

    private static final TreePath unfold$lambda$3(TreePath $unfolded, TreePath it) {
        Intrinsics.checkNotNullParameter((Object)$unfolded, (String)"$unfolded");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return INSTANCE.mergePaths(it, $unfolded);
    }
}

