/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl;

import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "", "()V", "experimentGroup", "", "getExperimentGroup", "()I", "isAllowed", "", "()Z", "isExperimentalMode", "tabExperiments", "Ljava/util/HashMap;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTabWithMlRanking;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "Lkotlin/collections/HashMap;", "tabsWithEnabledLogging", "", "", "kotlin.jvm.PlatformType", "getExperimentForTab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "tab", "isDisableExperiments", "isLoggingEnabledForTab", "tabId", "Companion", "Experiment", "ExperimentType", "intellij.searchEverywhereMl"})
public final class SearchEverywhereMlExperiment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isExperimentalMode = StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();
    @NotNull
    private final Set<String> tabsWithEnabledLogging;
    @NotNull
    private final HashMap<SearchEverywhereTabWithMlRanking, Experiment> tabExperiments;
    private static final int NUMBER_OF_GROUPS = 4;

    public SearchEverywhereMlExperiment() {
        Object[] objectArray = new String[]{SearchEverywhereTabWithMlRanking.ACTION.getTabId(), SearchEverywhereTabWithMlRanking.FILES.getTabId(), ClassSearchEverywhereContributor.class.getSimpleName(), SymbolSearchEverywhereContributor.class.getSimpleName(), "SearchEverywhereContributor.All"};
        this.tabsWithEnabledLogging = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[4];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.NO_ML)), TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.ENABLE_TYPOS))};
        objectArray[0] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ACTION), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[1] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.FILES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[2] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.CLASSES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL))};
        objectArray[3] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ALL), (Object)new Experiment(pairArray));
        this.tabExperiments = MapsKt.hashMapOf((Pair[])objectArray);
    }

    public final boolean isAllowed() {
        return this.isExperimentalMode && !Registry.is((String)"search.everywhere.force.disable.logging.ml");
    }

    /*
     * WARNING - void declaration
     */
    public final int getExperimentGroup() {
        int n;
        if (this.isExperimentalMode) {
            void var1_1;
            int experimentGroup = EventLogConfiguration.Companion.getInstance().getBucket() % 4;
            int registryExperimentGroup = Registry.intValue((String)"search.everywhere.ml.experiment.group");
            n = registryExperimentGroup >= 0 ? registryExperimentGroup : var1_1;
        } else {
            n = -1;
        }
        return n;
    }

    public final boolean isLoggingEnabledForTab(@NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        return this.tabsWithEnabledLogging.contains(tabId);
    }

    private final boolean isDisableExperiments(SearchEverywhereTabWithMlRanking tab) {
        String string = tab.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String key = "search.everywhere.force.disable.experiment." + string + ".ml";
        return Registry.is((String)key);
    }

    @NotNull
    public final ExperimentType getExperimentForTab(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (!this.isAllowed() || this.isDisableExperiments(tab)) {
            return ExperimentType.NO_EXPERIMENT;
        }
        Object object = this.tabExperiments.get((Object)tab);
        if (object == null || (object = object.getExperimentByGroup(this.getExperimentGroup())) == null) {
            object = ExperimentType.NO_EXPERIMENT;
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Companion;", "", "()V", "NUMBER_OF_GROUPS", "", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "", "experiments", "", "Lkotlin/Pair;", "", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "([Lkotlin/Pair;)V", "tabExperiments", "", "getExperimentByGroup", "group", "intellij.searchEverywhereMl"})
    private static final class Experiment {
        @NotNull
        private final Map<Integer, ExperimentType> tabExperiments;

        public Experiment(Pair<Integer, ? extends ExperimentType> ... experiments) {
            Intrinsics.checkNotNullParameter(experiments, (String)"experiments");
            this.tabExperiments = MapsKt.hashMapOf(Arrays.copyOf(experiments, experiments.length));
        }

        @NotNull
        public final ExperimentType getExperimentByGroup(int group) {
            return this.tabExperiments.getOrDefault(group, ExperimentType.NO_EXPERIMENT);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "", "(Ljava/lang/String;I)V", "NO_EXPERIMENT", "NO_ML", "USE_EXPERIMENTAL_MODEL", "NO_ML_FEATURES", "ENABLE_TYPOS", "intellij.searchEverywhereMl"})
    public static final class ExperimentType
    extends Enum<ExperimentType> {
        public static final /* enum */ ExperimentType NO_EXPERIMENT = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML = new ExperimentType();
        public static final /* enum */ ExperimentType USE_EXPERIMENTAL_MODEL = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML_FEATURES = new ExperimentType();
        public static final /* enum */ ExperimentType ENABLE_TYPOS = new ExperimentType();
        private static final /* synthetic */ ExperimentType[] $VALUES;

        public static ExperimentType[] values() {
            return (ExperimentType[])$VALUES.clone();
        }

        public static ExperimentType valueOf(String value) {
            return Enum.valueOf(ExperimentType.class, value);
        }

        static {
            $VALUES = experimentTypeArray = new ExperimentType[]{ExperimentType.NO_EXPERIMENT, ExperimentType.NO_ML, ExperimentType.USE_EXPERIMENTAL_MODEL, ExperimentType.NO_ML_FEATURES, ExperimentType.ENABLE_TYPOS};
        }
    }
}

