/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public abstract class ProjectUsagesCollector
extends FeatureUsagesCollector {
    @ApiStatus.Internal
    public static final ExtensionPointName<ProjectUsagesCollector> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.projectUsagesCollector");

    @NotNull
    public static Set<ProjectUsagesCollector> getExtensions(@NotNull UsagesCollectorConsumer invoker) {
        if (invoker == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(0);
        }
        Set<ProjectUsagesCollector> set = ProjectUsagesCollector.getExtensions(invoker, EP_NAME);
        if (set == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public CancellablePromise<? extends Set<MetricEvent>> getMetrics(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(2);
        }
        if (this.requiresReadAccess()) {
            NonBlockingReadAction action = ReadAction.nonBlocking(() -> project.isDisposed() ? Collections.emptySet() : this.getMetrics(project));
            if (indicator != null) {
                action = action.wrapProgress(indicator);
            }
            if (this.requiresSmartMode()) {
                action = action.inSmartMode(project);
            }
            CancellablePromise cancellablePromise = action.expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance());
            if (cancellablePromise == null) {
                ProjectUsagesCollector.$$$reportNull$$$0(3);
            }
            return cancellablePromise;
        }
        CancellablePromise cancellablePromise = Promises.resolvedCancellablePromise(this.getMetrics(project));
        if (cancellablePromise == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(4);
        }
        return cancellablePromise;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(5);
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            ProjectUsagesCollector.$$$reportNull$$$0(6);
        }
        return set;
    }

    protected boolean requiresReadAccess() {
        return false;
    }

    protected boolean requiresSmartMode() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

