/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;

    public RecentStringInterner(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecentStringInterner.$$$reportNull$$$0(0);
        }
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        int capacity = 8192;
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myInterns[i] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @Override
                @NotNull
                public String createValue(String key) {
                    String string2 = key;
                    if (string2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                @Override
                protected void putToProtectedQueue(String key, @NotNull String value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.putToProtectedQueue(value, value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/containers/RecentStringInterner$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/containers/RecentStringInterner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "putToProtectedQueue";
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myStripeLocks[i] = new ReentrantLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        LowMemoryWatcher.register(this::clear, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null -> null")
    @Nullable
    public String get(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        this.myStripeLocks[stripe].lock();
        try {
            String string2 = this.myInterns[stripe].get(s);
            return string2;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    public void clear() {
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myStripeLocks[i].lock();
            try {
                this.myInterns[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/containers/RecentStringInterner", "<init>"));
    }
}

