/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class WeakHashSet<T>
extends AbstractSet<T> {
    private final Set<MyRef<T>> set = new HashSet<MyRef<T>>();
    private final ReferenceQueue<T> queue = new ReferenceQueue();

    WeakHashSet() {
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<Object> iterator2 = ContainerUtil.filterIterator(ContainerUtil.mapIterator(this.set.iterator(), Reference::get), Objects::nonNull);
        if (iterator2 == null) {
            WeakHashSet.$$$reportNull$$$0(0);
        }
        return iterator2;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(@NotNull T t) {
        if (t == null) {
            WeakHashSet.$$$reportNull$$$0(1);
        }
        this.processQueue();
        MyRef<T> ref = new MyRef<T>(t, this.queue);
        return this.set.add(ref);
    }

    @Override
    public boolean remove(@NotNull Object o) {
        if (o == null) {
            WeakHashSet.$$$reportNull$$$0(2);
        }
        this.processQueue();
        return this.set.remove(new MyRef<Object>(o, null));
    }

    @Override
    public boolean contains(@NotNull Object o) {
        if (o == null) {
            WeakHashSet.$$$reportNull$$$0(3);
        }
        this.processQueue();
        return this.set.contains(new MyRef<Object>(o, null));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private void processQueue() {
        MyRef ref;
        while ((ref = (MyRef)this.queue.poll()) != null) {
            this.set.remove(ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/WeakHashSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/WeakHashSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRef<T>
    extends WeakReference<T> {
        private final int myHashCode;

        MyRef(@NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyRef.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.myHashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef otherRef = (MyRef)obj;
            return Comparing.equal(otherRef.get(), this.get());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/WeakHashSet$MyRef", "<init>"));
        }
    }
}

