/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;

public class XMLEntityResolver
implements IXMLEntityResolver {
    private Hashtable entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;");
        this.entities.put("quot", "&#34;");
        this.entities.put("apos", "&#39;");
        this.entities.put("lt", "&#60;");
        this.entities.put("gt", "&#62;");
    }

    protected void finalize() throws Throwable {
        this.entities.clear();
        this.entities = null;
        super.finalize();
    }

    public void addInternalEntity(String string2, String string3) {
        if (!this.entities.containsKey(string2)) {
            this.entities.put(string2, string3);
        }
    }

    public void addExternalEntity(String string2, String string3, String string4) {
        if (!this.entities.containsKey(string2)) {
            this.entities.put(string2, new String[]{string3, string4});
        }
    }

    public Reader getEntity(IXMLReader iXMLReader, String string2) throws XMLParseException {
        Object v = this.entities.get(string2);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return new StringReader((String)v);
        }
        String[] stringArray = (String[])v;
        return this.openExternalEntity(iXMLReader, stringArray[0], stringArray[1]);
    }

    public boolean isExternalEntity(String string2) {
        Object v = this.entities.get(string2);
        return !(v instanceof String);
    }

    protected Reader openExternalEntity(IXMLReader iXMLReader, String string2, String string3) throws XMLParseException {
        String string4 = iXMLReader.getSystemID();
        try {
            return iXMLReader.openStream(string2, string3);
        }
        catch (Exception exception) {
            throw new XMLParseException(string4, iXMLReader.getLineNr(), "Could not open external entity at system ID: " + string3);
        }
    }
}

