/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.runtimeModuleRepository.jps.build;

import com.intellij.devkit.runtimeModuleRepository.jps.build.RuntimeModuleRepositoryBuilder;
import com.intellij.devkit.runtimeModuleRepository.jps.impl.DevkitRuntimeModuleRepositoryJpsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleInducedTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006,"}, d2={"Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget;", "Lorg/jetbrains/jps/builders/BuildTarget;", "Lorg/jetbrains/jps/builders/BuildRootDescriptor;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "(Lorg/jetbrains/jps/model/JpsProject;)V", "getProject", "()Lorg/jetbrains/jps/model/JpsProject;", "computeDependencies", "", "targetRegistry", "Lorg/jetbrains/jps/builders/BuildTargetRegistry;", "outputIndex", "Lorg/jetbrains/jps/builders/TargetOutputIndex;", "computeDependenciesDigest", "", "pd", "Lorg/jetbrains/jps/cmdline/ProjectDescriptor;", "computeRootDescriptors", "", "model", "Lorg/jetbrains/jps/model/JpsModel;", "index", "Lorg/jetbrains/jps/indices/ModuleExcludeIndex;", "ignoredFileIndex", "Lorg/jetbrains/jps/indices/IgnoredFileIndex;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "findRootDescriptor", "rootId", "", "rootIndex", "Lorg/jetbrains/jps/builders/BuildRootIndex;", "getId", "getOutputRoots", "Ljava/io/File;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getPresentableName", "writeConfiguration", "", "out", "Ljava/io/PrintWriter;", "Companion", "intellij.devkit.runtimeModuleRepository.jps"})
@SourceDebugExtension(value={"SMAP\nRuntimeModuleRepositoryTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeModuleRepositoryTarget.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n17#2,6:137\n1855#3:143\n1855#3,2:144\n1856#3:146\n1855#3,2:147\n1855#3,2:149\n10#4:151\n*S KotlinDebug\n*F\n+ 1 RuntimeModuleRepositoryTarget.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget\n*L\n60#1:137,6\n81#1:143\n83#1:144,2\n81#1:146\n98#1:147,2\n77#1:149,2\n106#1:151\n*E\n"})
public final class RuntimeModuleRepositoryTarget
extends BuildTarget<BuildRootDescriptor> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JpsProject project;
    @NotNull
    private static final Logger LOG;

    public RuntimeModuleRepositoryTarget(@NotNull JpsProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BuildTargetType)Companion);
        this.project = project;
    }

    @NotNull
    public final JpsProject getProject() {
        return this.project;
    }

    @NotNull
    public String getId() {
        return "project";
    }

    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        Intrinsics.checkNotNullParameter((Object)targetRegistry, (String)"targetRegistry");
        Intrinsics.checkNotNullParameter((Object)outputIndex, (String)"outputIndex");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)ignoredFileIndex, (String)"ignoredFileIndex");
        Intrinsics.checkNotNullParameter((Object)dataPaths, (String)"dataPaths");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        Intrinsics.checkNotNullParameter((Object)rootId, (String)"rootId");
        Intrinsics.checkNotNullParameter((Object)rootIndex, (String)"rootIndex");
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("build.target.intellij.runtime.module.descriptors", new Object[0]);
    }

    @NotNull
    public Collection<File> getOutputRoots(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaProjectExtension jpsJavaProjectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        String string = jpsJavaProjectExtension != null ? jpsJavaProjectExtension.getOutputUrl() : null;
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String outputUrl = string;
        return CollectionsKt.listOf((Object)new File(JpsPathUtil.urlToFile((String)outputUrl), "module-descriptors.jar"));
    }

    public void writeConfiguration(@NotNull ProjectDescriptor pd, @NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter((Object)pd, (String)"pd");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        byte[] digest = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        digest = this.computeDependenciesDigest(pd);
        long time = System.currentTimeMillis() - start$iv;
        LOG.info("Dependencies digest computed in " + time + "ms");
        out.println("0.1.1");
        out.println(StringUtil.toHexString((byte[])digest));
    }

    private final byte[] computeDependenciesDigest(ProjectDescriptor pd) {
        MessageDigest digest = DigestUtil.sha256();
        PathRelativizerService relativizer = pd.dataManager.getRelativizer();
        List list = pd.getProject().getModules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pd.project.modules");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsModule module = (JpsModule)element$iv;
            boolean bl = false;
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            RuntimeModuleRepositoryTarget.computeDependenciesDigest$update(digest, string);
            List list2 = module.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"module.sourceRoots");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JpsModuleSourceRoot sourceRoot = (JpsModuleSourceRoot)element$iv2;
                boolean bl2 = false;
                String string2 = relativizer.toRelative(sourceRoot.getFile().getAbsolutePath());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"relativizer.toRelative(s\u2026ceRoot.file.absolutePath)");
                RuntimeModuleRepositoryTarget.computeDependenciesDigest$update(digest, string2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
            RuntimeModuleRepositoryBuilder.Companion.enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(module).processModuleAndLibraries(arg_0 -> RuntimeModuleRepositoryTarget.computeDependenciesDigest$lambda$5$lambda$3((Function1)new Function1<JpsModule, Unit>(digest){
                final /* synthetic */ MessageDigest $digest;
                {
                    this.$digest = $digest;
                    super(1);
                }

                public final void invoke(JpsModule it) {
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    RuntimeModuleRepositoryTarget.access$computeDependenciesDigest$update(this.$digest, string);
                }
            }, arg_0), arg_0 -> RuntimeModuleRepositoryTarget.computeDependenciesDigest$lambda$5$lambda$4((Function1)new Function1<JpsLibrary, Unit>(digest, relativizer){
                final /* synthetic */ MessageDigest $digest;
                final /* synthetic */ PathRelativizerService $relativizer;
                {
                    this.$digest = $digest;
                    this.$relativizer = $relativizer;
                    super(1);
                }

                public final void invoke(JpsLibrary library) {
                    String string = library.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"library.name");
                    RuntimeModuleRepositoryTarget.access$computeDependenciesDigest$update(this.$digest, string);
                    if (library.createReference().getParentReference() instanceof JpsModuleReference) {
                        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"library");
                        RuntimeModuleRepositoryTarget.access$computeDependenciesDigest$updateFromRoots(this.$digest, this.$relativizer, library);
                    }
                }
            }, arg_0));
        }
        List list3 = pd.getProject().getLibraryCollection().getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"pd.project.libraryCollection.libraries");
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsLibrary library = (JpsLibrary)element$iv;
            boolean bl = false;
            String string = library.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"library.name");
            RuntimeModuleRepositoryTarget.computeDependenciesDigest$update(digest, string);
            Intrinsics.checkNotNullExpressionValue((Object)library, (String)"library");
            RuntimeModuleRepositoryTarget.computeDependenciesDigest$updateFromRoots(digest, relativizer, library);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return byArray;
    }

    private static final void computeDependenciesDigest$update(MessageDigest $this$computeDependenciesDigest_u24update, String string) {
        $this$computeDependenciesDigest_u24update.update(StringsKt.encodeToByteArray((String)string));
        $this$computeDependenciesDigest_u24update.update((byte)10);
    }

    private static final void computeDependenciesDigest$updateFromRoots(MessageDigest $this$computeDependenciesDigest_u24updateFromRoots, PathRelativizerService relativizer, JpsLibrary library) {
        List list = library.getRoots(JpsOrderRootType.COMPILED);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"library.getRoots(JpsOrderRootType.COMPILED)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsLibraryRoot it = (JpsLibraryRoot)element$iv;
            boolean bl = false;
            String string = relativizer.toRelative(JpsPathUtil.urlToPath((String)it.getUrl()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"relativizer.toRelative(J\u2026thUtil.urlToPath(it.url))");
            RuntimeModuleRepositoryTarget.computeDependenciesDigest$update($this$computeDependenciesDigest_u24updateFromRoots, string);
        }
    }

    private static final void computeDependenciesDigest$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void computeDependenciesDigest$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$computeDependenciesDigest$update(MessageDigest $receiver, String string) {
        RuntimeModuleRepositoryTarget.computeDependenciesDigest$update($receiver, string);
    }

    public static final /* synthetic */ void access$computeDependenciesDigest$updateFromRoots(MessageDigest $receiver, PathRelativizerService relativizer, JpsLibrary library) {
        RuntimeModuleRepositoryTarget.computeDependenciesDigest$updateFromRoots($receiver, relativizer, library);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RuntimeModuleRepositoryTarget.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget$Companion;", "Lorg/jetbrains/jps/builders/BuildTargetType;", "Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget;", "Lorg/jetbrains/jps/builders/ModuleInducedTargetType;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "computeAllTargets", "", "model", "Lorg/jetbrains/jps/model/JpsModel;", "createLoader", "Lorg/jetbrains/jps/builders/BuildTargetLoader;", "isIntellijPlatformProject", "", "project", "Lorg/jetbrains/jps/model/JpsProject;", "intellij.devkit.runtimeModuleRepository.jps"})
    @SourceDebugExtension(value={"SMAP\nRuntimeModuleRepositoryTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeModuleRepositoryTarget.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1747#2,3:137\n*S KotlinDebug\n*F\n+ 1 RuntimeModuleRepositoryTarget.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget$Companion\n*L\n127#1:137,3\n*E\n"})
    public static final class Companion
    extends BuildTargetType<RuntimeModuleRepositoryTarget>
    implements ModuleInducedTargetType {
        private Companion() {
            super("intellij-runtime-module-repository");
        }

        @NotNull
        public List<RuntimeModuleRepositoryTarget> computeAllTargets(@NotNull JpsModel model) {
            List list;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            JpsProject jpsProject = model.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"model.project");
            if (this.isIntellijPlatformProject(jpsProject)) {
                JpsProject jpsProject2 = model.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)jpsProject2, (String)"model.project");
                list = CollectionsKt.listOf((Object)((Object)new RuntimeModuleRepositoryTarget(jpsProject2)));
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public BuildTargetLoader<RuntimeModuleRepositoryTarget> createLoader(@NotNull JpsModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return (BuildTargetLoader)new BuildTargetLoader<RuntimeModuleRepositoryTarget>(model){
                final /* synthetic */ JpsModel $model;
                {
                    this.$model = $model;
                }

                @Nullable
                public RuntimeModuleRepositoryTarget createTarget(@NotNull String targetId) {
                    RuntimeModuleRepositoryTarget runtimeModuleRepositoryTarget;
                    Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
                    JpsProject jpsProject = this.$model.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"model.project");
                    if (com.intellij.devkit.runtimeModuleRepository.jps.build.RuntimeModuleRepositoryTarget$Companion.access$isIntellijPlatformProject(RuntimeModuleRepositoryTarget.Companion, jpsProject)) {
                        JpsProject jpsProject2 = this.$model.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)jpsProject2, (String)"model.project");
                        runtimeModuleRepositoryTarget = new RuntimeModuleRepositoryTarget(jpsProject2);
                    } else {
                        runtimeModuleRepositoryTarget = null;
                    }
                    return runtimeModuleRepositoryTarget;
                }
            };
        }

        private final boolean isIntellijPlatformProject(JpsProject project) {
            boolean bl;
            block3: {
                List list = project.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.modules");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JpsModule it = (JpsModule)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"intellij.idea.community.main") || Intrinsics.areEqual((Object)it.getName(), (Object)"intellij.platform.commercial"))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$isIntellijPlatformProject(Companion $this, JpsProject project) {
            return $this.isIntellijPlatformProject(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

