/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.javac.JpsFileObject;

public final class FileObjectKindFilter<T> {
    private final Function<? super T, String> myToNameConverter;
    private final Map<JavaFileObject.Kind, BooleanFunction<T>> myFilterMap;

    public FileObjectKindFilter(Function<? super T, String> toNameConverter) {
        this.myToNameConverter = toNameConverter;
        EnumMap<JavaFileObject.Kind, Object> filterMap = new EnumMap<JavaFileObject.Kind, Object>(JavaFileObject.Kind.class);
        for (final JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (kind == JavaFileObject.Kind.OTHER) {
                filterMap.put(kind, new BooleanFunction<T>(){

                    public boolean fun(T data) {
                        return JpsFileObject.findKind((String)FileObjectKindFilter.this.myToNameConverter.fun(data)) == JavaFileObject.Kind.OTHER;
                    }
                });
                continue;
            }
            filterMap.put(kind, new BooleanFunction<T>(){

                public boolean fun(T data) {
                    String name = (String)FileObjectKindFilter.this.myToNameConverter.fun(data);
                    return name.regionMatches(true, name.length() - kind.extension.length(), kind.extension, 0, kind.extension.length());
                }
            });
        }
        this.myFilterMap = Collections.unmodifiableMap(filterMap);
    }

    public BooleanFunction<T> getFor(final Set<JavaFileObject.Kind> kinds) {
        Iterator<JavaFileObject.Kind> it = kinds.iterator();
        if (it.hasNext()) {
            JavaFileObject.Kind kind = it.next();
            if (!it.hasNext()) {
                return this.myFilterMap.get((Object)kind);
            }
        }
        return new BooleanFunction<T>(){

            public boolean fun(T data) {
                for (JavaFileObject.Kind kind : kinds) {
                    if (!((BooleanFunction)FileObjectKindFilter.this.myFilterMap.get((Object)kind)).fun(data)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

