/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum ArtifactKind {
    ARTIFACT("", "jar"),
    SOURCES("sources", "jar"),
    JAVADOC("javadoc", "jar"),
    ANNOTATIONS("annotations", "zip"),
    AAR_ARTIFACT("", "aar"),
    POM("", "pom"),
    ALL("all", "jar"),
    HTTP("http", "jar"),
    DLL("", "dll");

    private final String myClassifier;
    private final String myExtension;

    private ArtifactKind(String classifier, String extension) {
        this.myClassifier = classifier;
        this.myExtension = extension;
    }

    @NotNull
    public String getClassifier() {
        String string = this.myClassifier;
        if (string == null) {
            ArtifactKind.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getExtension() {
        String string = this.myExtension;
        if (string == null) {
            ArtifactKind.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static ArtifactKind find(String classifier, String extension) {
        for (ArtifactKind kind : ArtifactKind.values()) {
            if (!kind.getClassifier().equals(classifier) || !kind.getExtension().equals(extension)) continue;
            return kind;
        }
        return null;
    }

    public static EnumSet<ArtifactKind> kindsOf(boolean sources, boolean javadoc, String ... artifactPackaging) {
        EnumSet<ArtifactKind> result = EnumSet.noneOf(ArtifactKind.class);
        if (sources) {
            result.add(SOURCES);
        }
        if (javadoc) {
            result.add(JAVADOC);
        }
        if (artifactPackaging.length == 0 || artifactPackaging.length == 1 && artifactPackaging[0] == null) {
            result.add(ARTIFACT);
        } else {
            for (String packaging : artifactPackaging) {
                ArtifactKind artifact = ArtifactKind.find(ARTIFACT.getClassifier(), packaging);
                if (artifact == null) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/aether/ArtifactKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

