/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import icons.XpathIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.XsltConfig;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.jetbrains.annotations.NotNull;

public class XsltTreeStructureProvider
implements TreeStructureProvider {
    private final Project myProject;

    public XsltTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent == null) {
            XsltTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            XsltTreeStructureProvider.$$$reportNull$$$0(1);
        }
        Collection<AbstractTreeNode<?>> l = children;
        int i = 0;
        for (AbstractTreeNode<?> o : children) {
            ProjectViewNode node;
            Object element;
            if (o instanceof ProjectViewNode && (element = (node = (ProjectViewNode)o).getValue()) instanceof PsiFile) {
                ProgressManager.checkCanceled();
                if (XsltSupport.isXsltFile((PsiFile)element)) {
                    if (l == children && l.getClass() != ArrayList.class) {
                        l = new ArrayList(children);
                    }
                    XsltFileNode fileNode = new XsltFileNode(this.myProject, (PsiFile)element, settings);
                    ((List)l).set(i, fileNode);
                }
            }
            ++i;
        }
        Collection<AbstractTreeNode<?>> collection = l;
        if (collection == null) {
            XsltTreeStructureProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class XsltFileNode
    extends PsiFileNode {
        private final FileAssociationsManager myInstance;
        private final XsltConfig myConfig;

        XsltFileNode(Project project, @NotNull PsiFile psiFile, ViewSettings viewSettings) {
            if (psiFile == null) {
                XsltFileNode.$$$reportNull$$$0(0);
            }
            super(project, psiFile, viewSettings);
            this.myInstance = FileAssociationsManager.getInstance(this.myProject);
            this.myConfig = XsltConfig.getInstance();
        }

        public void updateImpl(@NotNull PresentationData presentationData) {
            if (presentationData == null) {
                XsltFileNode.$$$reportNull$$$0(1);
            }
            super.updateImpl(presentationData);
            PsiFile[] psiFiles = this.myInstance.getAssociationsFor((PsiFile)this.getValue());
            Icon icon = XsltSupport.createXsltIcon(presentationData.getIcon(false));
            if (psiFiles.length > 0) {
                icon = LayeredIcon.create((Icon)icon, (Icon)XpathIcons.Association_small);
            }
            presentationData.setIcon(icon);
        }

        public boolean expandOnDoubleClick() {
            return false;
        }

        public Collection<AbstractTreeNode<?>> getChildrenImpl() {
            PsiFile[] psiFiles;
            if (this.myConfig.isShowLinkedFiles() && (psiFiles = this.myInstance.getAssociationsFor((PsiFile)this.getValue())).length > 0) {
                return ProjectViewNode.wrap(Arrays.asList(psiFiles), (Project)this.myProject, PsiFileNode.class, (ViewSettings)this.getSettings());
            }
            return super.getChildrenImpl();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationData";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider$XsltFileNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

