/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.SimpleVariableContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.ui.AddNamespaceDialog;
import org.intellij.plugins.xpathView.ui.Expression;
import org.intellij.plugins.xpathView.ui.ExpressionCellEditor;
import org.intellij.plugins.xpathView.ui.ExpressionCellRenderer;
import org.intellij.plugins.xpathView.util.Copyable;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditContextDialog
extends DialogWrapper {
    private final Set<String> myUnresolvedPrefixes;
    private final JBTable myVariableTable;
    private final VariableTableModel myVariableTableModel;
    private final JBTable myNamespaceTable;
    private final NamespaceTableModel myNamespaceTableModel;
    private final ContextProvider myContextProvider;
    private JBSplitter mySplitter;

    public EditContextDialog(Project project, Set<String> unresolvedPrefixes, Collection<Namespace> namespaces, Collection<Variable> variables, ContextProvider contextProvider) {
        super(project, false);
        this.myUnresolvedPrefixes = unresolvedPrefixes;
        this.setTitle(XPathBundle.message("dialog.title.edit.xpath.context", new Object[0]));
        this.setModal(true);
        this.myContextProvider = new MyContextProvider(contextProvider);
        List<Variable> m = Copyable.Util.copy(variables);
        this.myVariableTableModel = new VariableTableModel(m, project, XPathFileType.XPATH);
        this.myVariableTable = new JBTable((TableModel)this.myVariableTableModel);
        this.myVariableTable.setDefaultRenderer(String.class, (TableCellRenderer)new VariableCellRenderer(m));
        this.myVariableTable.setDefaultRenderer(Expression.class, (TableCellRenderer)new ExpressionCellRenderer(project));
        this.myVariableTable.setDefaultEditor(Expression.class, (TableCellEditor)new ExpressionCellEditor(project));
        int width = new JBLabel((String)XPathBundle.message((String)"label.name", (Object[])new Object[0])).getPreferredSize().width;
        this.myVariableTable.getColumnModel().getColumn(0).setMinWidth(width);
        this.myVariableTable.getColumnModel().getColumn(0).setMaxWidth(width * 5);
        this.myVariableTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)130));
        List<Namespace> n = Copyable.Util.copy(namespaces);
        this.myNamespaceTableModel = new NamespaceTableModel(n);
        this.myNamespaceTable = new JBTable((TableModel)this.myNamespaceTableModel);
        this.myNamespaceTable.setDefaultRenderer(String.class, (TableCellRenderer)new NamespaceCellRenderer(n));
        width = new JBLabel((String)XPathBundle.message((String)"label.prefix", (Object[])new Object[0])).getPreferredSize().width;
        this.myNamespaceTable.getColumnModel().getColumn(0).setMinWidth(width);
        this.myNamespaceTable.getColumnModel().getColumn(0).setMaxWidth(width * 4);
        this.myNamespaceTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)150));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel p = ToolbarDecorator.createDecorator((JTable)this.myVariableTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditContextDialog.this.stopVarEditing();
                EditContextDialog.this.myVariableTableModel.addVariable();
                EditContextDialog.this.myNamespaceTable.editCellAt(EditContextDialog.this.myVariableTableModel.getRowCount() - 1, 0);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditContextDialog.this.myVariableTableModel.removeVariable(EditContextDialog.this.myVariableTable.getSelectedRow());
            }
        }).disableUpDownActions().createPanel();
        UIUtil.addBorder((JComponent)p, (Border)IdeBorderFactory.createTitledBorder((String)XPathBundle.message("border.title.variables", new Object[0]), (boolean)false));
        JPanel n = ToolbarDecorator.createDecorator((JTable)this.myNamespaceTable).setAddAction(this.myContextProvider.getContextElement() != null ? null : new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ExternalResourceManager erm = ExternalResourceManager.getInstance();
                ArrayList<String> allURIs = new ArrayList<String>(Arrays.asList(erm.getResourceUrls(null, true)));
                Collection<Namespace> namespaces = EditContextDialog.this.myNamespaceTableModel.getNamespaces();
                for (Namespace namespace : namespaces) {
                    allURIs.remove(namespace.getUri());
                }
                Collections.sort(allURIs);
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)EditContextDialog.this.myNamespaceTable);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                AddNamespaceDialog dlg = new AddNamespaceDialog(project, EditContextDialog.this.myUnresolvedPrefixes, allURIs, AddNamespaceDialog.Mode.EDITABLE);
                if (dlg.showAndGet()) {
                    EditContextDialog.this.myNamespaceTableModel.addNamespace(new Namespace(dlg.getPrefix(), dlg.getURI()));
                }
            }
        }).setRemoveAction(this.myContextProvider.getContextElement() != null ? null : new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditContextDialog.this.myNamespaceTableModel.removeNamespace(EditContextDialog.this.myNamespaceTable.getSelectedRow());
            }
        }).disableUpDownActions().createPanel();
        UIUtil.addBorder((JComponent)n, (Border)IdeBorderFactory.createTitledBorder((String)XPathBundle.message("border.title.namespaces", new Object[0]), (boolean)false));
        this.mySplitter = new JBSplitter(true, this.getDimensionServiceKey(), 0.4f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)n);
        this.mySplitter.setSecondComponent((JComponent)p);
        return this.mySplitter;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName() + ".DIMENSION_SERVICE_KEY";
        if (string == null) {
            EditContextDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Pair<Collection<Namespace>, Collection<Variable>> getContext() {
        assert (this.isOK());
        return Pair.create(this.myNamespaceTableModel.getNamespaces(), this.myVariableTableModel.getVariables());
    }

    protected void doOKAction() {
        this.stopVarEditing();
        this.stopNamespaceEditing();
        List<Expression> expressions = this.myVariableTableModel.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            String error;
            Expression expression = expressions.get(i);
            String name = (String)this.myVariableTableModel.getValueAt(i, 0);
            String expr = expression.getExpression();
            if ((expr == null || expr.trim().length() == 0) && (name == null || name.trim().length() == 0) || (error = EditContextDialog.getError(expression)) == null) continue;
            Messages.showErrorDialog((Project)expression.getFile().getProject(), (String)XPathBundle.message("dialog.message.error.in.xpath.expression.for.variable", name, error), (String)XPathBundle.message("dialog.title.xpath.error", new Object[0]));
            this.myVariableTable.getSelectionModel().setSelectionInterval(i, i);
            return;
        }
        super.doOKAction();
    }

    private static String getError(Expression expression) {
        return MyPsiUtil.checkFile(expression.getFile());
    }

    private void stopVarEditing() {
        TableCellEditor cellEditor = this.myVariableTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private void stopNamespaceEditing() {
        TableCellEditor cellEditor = this.myNamespaceTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/EditContextDialog", "getDimensionServiceKey"));
    }

    private class MyContextProvider
    extends ContextProvider {
        private final MyNamespaceContext myNamespaceContext;
        private final MyVariableContext myVariableContext;
        private final ContextProvider myContextProvider;

        MyContextProvider(ContextProvider contextProvider) {
            this.myContextProvider = contextProvider;
            this.myNamespaceContext = new MyNamespaceContext();
            this.myVariableContext = new MyVariableContext();
        }

        @Override
        @NotNull
        public ContextType getContextType() {
            ContextType contextType = this.myContextProvider.getContextType();
            if (contextType == null) {
                MyContextProvider.$$$reportNull$$$0(0);
            }
            return contextType;
        }

        @Override
        @Nullable
        public XmlElement getContextElement() {
            return this.myContextProvider.getContextElement();
        }

        @Override
        @Nullable
        public NamespaceContext getNamespaceContext() {
            return this.myNamespaceContext;
        }

        @Override
        @Nullable
        public VariableContext getVariableContext() {
            return this.myVariableContext;
        }

        @Override
        @Nullable
        public Set<QName> getAttributes(boolean forValidation) {
            return this.myContextProvider.getAttributes(forValidation);
        }

        @Override
        @Nullable
        public Set<QName> getElements(boolean forValidation) {
            return this.myContextProvider.getElements(forValidation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/EditContextDialog$MyContextProvider", "getContextType"));
        }
    }

    private class VariableTableModel
    extends AbstractTableModel {
        private final Project myProject;
        private final LanguageFileType myFileType;
        private final List<Variable> myVariables;
        private final List<Expression> myList;

        VariableTableModel(List<Variable> variables, Project project, LanguageFileType fileType) {
            this.myVariables = variables;
            this.myProject = project;
            this.myFileType = fileType;
            this.myList = new ArrayList<Expression>(variables.size());
            for (Variable variable : variables) {
                Expression expression = Expression.create(project, fileType, variable.getExpression());
                EditContextDialog.this.myContextProvider.attachTo(expression.getFile());
                this.myList.add(expression);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Expression.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? XPathBundle.message("name", new Object[0]) : XPathBundle.message("expression", new Object[0]);
        }

        @Override
        public int getRowCount() {
            return this.myVariables.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Variable variable = this.myVariables.get(rowIndex);
            if (columnIndex == 0) {
                return variable.getName();
            }
            return this.myList.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.myVariables.size()) {
                return;
            }
            Variable variable = this.myVariables.get(rowIndex);
            if (columnIndex == 0) {
                variable.setName((String)aValue);
            } else {
                variable.setExpression(((Expression)aValue).getExpression());
            }
            this.fireTableDataChanged();
        }

        public Collection<Variable> getVariables() {
            return this.myVariables;
        }

        public List<Expression> getExpressions() {
            return this.myList;
        }

        public void addVariable() {
            Variable variable = new Variable();
            this.myVariables.add(variable);
            Expression expression = Expression.create(this.myProject, this.myFileType);
            EditContextDialog.this.myContextProvider.attachTo(expression.getFile());
            this.myList.add(expression);
            int firstRow = this.myVariables.size() - 1;
            this.fireTableRowsInserted(firstRow, firstRow);
        }

        public void removeVariable(int selectedRow) {
            this.myVariables.remove(selectedRow);
            this.myList.remove(selectedRow);
            this.fireTableRowsDeleted(selectedRow, selectedRow);
        }
    }

    private static class VariableCellRenderer
    extends DefaultTableCellRenderer {
        private final List<Variable> myVariables;

        VariableCellRenderer(List<Variable> variables) {
            this.myVariables = variables;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object _value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, _value, isSelected, hasFocus, row, column);
            this.setForeground(table.getForeground());
            this.setToolTipText(null);
            for (int i = 0; i < this.myVariables.size(); ++i) {
                Variable variable = this.myVariables.get(i);
                if (i != row && variable.getName().equals(_value)) {
                    this.setForeground((Color)JBColor.RED);
                    this.setToolTipText(XPathBundle.message("tooltip.duplicate.variable", new Object[0]));
                    continue;
                }
                if (variable.getExpression().length() != 0) continue;
                this.setForeground(PlatformColors.BLUE);
                this.setToolTipText(XPathBundle.message("tooltip.empty.expression.variable.will.evaluate.to.empty.nodeset", new Object[0]));
            }
            return this;
        }
    }

    private static class NamespaceTableModel
    extends AbstractTableModel {
        private final List<Namespace> myNamespaces;

        NamespaceTableModel(List<Namespace> namespaces) {
            this.myNamespaces = namespaces;
        }

        public Collection<Namespace> getNamespaces() {
            return this.myNamespaces;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? XPathBundle.message("prefix", new Object[0]) : XPathBundle.message("uri", new Object[0]);
        }

        @Override
        public int getRowCount() {
            return this.myNamespaces.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Namespace namespace = this.myNamespaces.get(rowIndex);
            return columnIndex == 0 ? namespace.getPrefix() : namespace.getUri();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                Namespace namespace = this.myNamespaces.get(rowIndex);
                namespace.setPrefix((String)aValue);
            }
        }

        public void addNamespace(Namespace namespace) {
            int firstRow = this.myNamespaces.size();
            this.myNamespaces.add(namespace);
            this.fireTableRowsInserted(firstRow, firstRow);
        }

        public void removeNamespace(int selectedRow) {
            this.myNamespaces.remove(selectedRow);
            this.fireTableRowsDeleted(selectedRow, selectedRow);
        }
    }

    private static class NamespaceCellRenderer
    extends DefaultTableCellRenderer {
        private final List<Namespace> myNamespaces;

        NamespaceCellRenderer(List<Namespace> namespaces) {
            this.myNamespaces = namespaces;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(table.getForeground());
            String prefix = this.myNamespaces.get(row).getPrefix();
            if (column == 1 && prefix == null || prefix.length() == 0) {
                this.setForeground(PlatformColors.BLUE);
            } else if (column == 0) {
                for (int i = 0; i < this.myNamespaces.size(); ++i) {
                    Namespace namespace = this.myNamespaces.get(i);
                    if (i == row || !namespace.getPrefix().equals(value)) continue;
                    this.setForeground((Color)JBColor.RED);
                    break;
                }
            }
            return this;
        }
    }

    private class MyVariableContext
    extends SimpleVariableContext {
        private MyVariableContext() {
        }

        public String @NotNull [] getVariablesInScope(XPathElement element) {
            Collection<Variable> variables = EditContextDialog.this.myVariableTableModel.getVariables();
            String[] stringArray = Variable.asSet(variables).toArray(new String[variables.size()]);
            if (stringArray == null) {
                MyVariableContext.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/EditContextDialog$MyVariableContext", "getVariablesInScope"));
        }
    }

    private class MyNamespaceContext
    implements NamespaceContext {
        private MyNamespaceContext() {
        }

        @Override
        @Nullable
        public String getNamespaceURI(String prefix, XmlElement context) {
            return Namespace.makeMap(EditContextDialog.this.myNamespaceTableModel.getNamespaces()).get(prefix);
        }

        @Override
        @Nullable
        public String getPrefixForURI(String uri, XmlElement context) {
            BidirectionalMap bidiMap = new BidirectionalMap();
            bidiMap.putAll(Namespace.makeMap(EditContextDialog.this.myNamespaceTableModel.getNamespaces()));
            List list = bidiMap.getKeysByValue((Object)uri);
            return list != null && list.size() > 0 ? (String)list.get(0) : null;
        }

        @Override
        @NotNull
        public Collection<String> getKnownPrefixes(XmlElement context) {
            Set<String> set = Namespace.makeMap(EditContextDialog.this.myNamespaceTableModel.getNamespaces()).keySet();
            if (set == null) {
                MyNamespaceContext.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        @Nullable
        public PsiElement resolve(String prefix, XmlElement context) {
            return null;
        }

        @Override
        public IntentionAction[] getUnresolvedNamespaceFixes(@NotNull PsiReference reference, String localName) {
            if (reference == null) {
                MyNamespaceContext.$$$reportNull$$$0(1);
            }
            return IntentionAction.EMPTY_ARRAY;
        }

        @Override
        public String getDefaultNamespace(XmlElement context) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/xpathView/ui/EditContextDialog$MyNamespaceContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKnownPrefixes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/xpathView/ui/EditContextDialog$MyNamespaceContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnresolvedNamespaceFixes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

