/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeTestEventProcessor
extends AbstractTestEventProcessor {
    public BeforeTestEventProcessor(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String suiteName = eventXml.getTestClassName();
        String fqClassName = eventXml.getTestClassName();
        String methodName = eventXml.getTestName();
        String displayName = eventXml.getTestDisplayName();
        this.doProcess(testId, parentTestId, suiteName, fqClassName, methodName, displayName);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(1);
        }
        this.getExecutionConsole().getFileComparisonEventPatcher().setBuiltInTestEventsUsed();
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String parentTestId = testEvent.getParentEventId();
        String suiteName = StringUtil.notNullize((String)testDescriptor.getSuiteName());
        String fqClassName = StringUtil.notNullize((String)testDescriptor.getClassName());
        String methodName = testDescriptor.getMethodName();
        String displayName = testDescriptor.getDisplayName();
        this.doProcess(testId, parentTestId, suiteName, fqClassName, methodName, displayName);
    }

    private void doProcess(@NotNull String testId, @Nullable String parentTestId, @NotNull String suiteName, @NotNull String fqClassName, @Nullable String methodName, @NotNull String displayName) {
        if (testId == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(2);
        }
        if (suiteName == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(3);
        }
        if (fqClassName == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(5);
        }
        GradleSMTestProxy testProxy = this.createTestProxy(parentTestId, suiteName, fqClassName, methodName, displayName);
        this.registerTestProxy(testId, testProxy);
        BeforeTestEventProcessor.traverseTestNodesFromChildToParent(testProxy, node -> {
            this.setParentIfNeeded((GradleSMTestProxy)((Object)node));
            this.setStartedIfNeeded((GradleSMTestProxy)((Object)node));
        });
    }

    private void setParentIfNeeded(@NotNull GradleSMTestProxy testProxy) {
        if (testProxy == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(6);
        }
        if (testProxy.getParent() == null) {
            String parentId = testProxy.getParentId();
            SMTestProxy parentNode = this.findParentTestProxy(parentId);
            parentNode.addChild((SMTestProxy)testProxy);
        }
    }

    private void setStartedIfNeeded(@NotNull GradleSMTestProxy testProxy) {
        if (testProxy == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(7);
        }
        if (!testProxy.isInProgress()) {
            if (testProxy.isSuite()) {
                testProxy.setStarted();
                this.getResultsViewer().onSuiteStarted((SMTestProxy)testProxy);
                this.getExecutionConsole().getEventPublisher().onSuiteStarted((SMTestProxy)testProxy);
            } else {
                testProxy.setStarted();
                this.getResultsViewer().onTestStarted((SMTestProxy)testProxy);
                this.getExecutionConsole().getEventPublisher().onTestStarted((SMTestProxy)testProxy);
            }
        }
    }

    private static void traverseTestNodesFromChildToParent(@NotNull GradleSMTestProxy node, @NotNull Consumer<GradleSMTestProxy> process) {
        if (node == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(8);
        }
        if (process == null) {
            BeforeTestEventProcessor.$$$reportNull$$$0(9);
        }
        while (node != null) {
            process.accept(node);
            node = (GradleSMTestProxy)((Object)ObjectUtils.tryCast((Object)node.getParent(), GradleSMTestProxy.class));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testEvent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeTestEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setParentIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setStartedIfNeeded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseTestNodesFromChildToParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

