/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.toml.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.config.GradleBuildscriptSearchScope;
import org.toml.lang.psi.TomlKeySegment;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/toml/findUsages/GradleVersionCatalogFindUsagesHandler;", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "tomlElement", "Lorg/toml/lang/psi/TomlKeySegment;", "(Lorg/toml/lang/psi/TomlKeySegment;)V", "getFindUsagesOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "VersionCatalogSearchScope", "intellij.gradle.java"})
public final class GradleVersionCatalogFindUsagesHandler
extends FindUsagesHandler {
    @NotNull
    private final TomlKeySegment tomlElement;

    public GradleVersionCatalogFindUsagesHandler(@NotNull TomlKeySegment tomlElement) {
        Intrinsics.checkNotNullParameter((Object)tomlElement, (String)"tomlElement");
        super((PsiElement)tomlElement);
        this.tomlElement = tomlElement;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions findUsagesOptions = super.getFindUsagesOptions(dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)findUsagesOptions, (String)"super.getFindUsagesOptions(dataContext)");
        FindUsagesOptions superOptions = findUsagesOptions;
        superOptions.searchScope = (SearchScope)new VersionCatalogSearchScope((PsiElement)this.tomlElement);
        return superOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/toml/findUsages/GradleVersionCatalogFindUsagesHandler$VersionCatalogSearchScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "buildscriptScope", "Lorg/jetbrains/plugins/gradle/config/GradleBuildscriptSearchScope;", "tomlScope", "Lorg/jetbrains/annotations/NotNull;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDisplayName", "", "isSearchInLibraries", "isSearchInModuleContent", "aModule", "Lcom/intellij/openapi/module/Module;", "intellij.gradle.java"})
    private static final class VersionCatalogSearchScope
    extends GlobalSearchScope {
        @NotNull
        private final GradleBuildscriptSearchScope buildscriptScope;
        @NotNull
        private final GlobalSearchScope tomlScope;

        public VersionCatalogSearchScope(@NotNull PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context.getProject());
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
            this.buildscriptScope = new GradleBuildscriptSearchScope(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)context.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(context.containingFile)");
            this.tomlScope = globalSearchScope;
        }

        public boolean contains(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.buildscriptScope.contains(file) || this.tomlScope.contains(file);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
            return this.buildscriptScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return this.buildscriptScope.isSearchInLibraries();
        }

        @NotNull
        public String getDisplayName() {
            String string = GradleInspectionBundle.message("gradle.version.catalog.search.scope", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"gradle.version.catalog.search.scope\")");
            return string;
        }
    }
}

