/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.DuplicatePropertyKeyAnnotationSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesAnnotator
implements Annotator {
    private static final ExtensionPointName<DuplicatePropertyKeyAnnotationSuppressor> EP_NAME = ExtensionPointName.create((String)"com.intellij.properties.duplicatePropertyKeyAnnotationSuppressor");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof Property)) {
            return;
        }
        Property property = (Property)element;
        PropertiesFile propertiesFile = property.getPropertiesFile();
        String key = property.getUnescapedKey();
        if (key == null) {
            return;
        }
        List<IProperty> others = propertiesFile.findPropertiesByKey(key);
        ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
        if (keyNode == null) {
            return;
        }
        if (others.size() != 1 && EP_NAME.findFirstSafe(suppressor -> suppressor.suppressAnnotationFor(property)) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PropertiesBundle.message("duplicate.property.key.error.message", new Object[0])).range(keyNode).withFix(PropertiesQuickFixFactory.getInstance().createRemovePropertyFix(property)).create();
        }
        PropertiesAnnotator.highlightTokens(property, keyNode, holder, new PropertiesHighlighter());
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode != null) {
            PropertiesAnnotator.highlightTokens(property, valueNode, holder, new PropertiesValueHighlighter());
        }
    }

    private static void highlightTokens(Property property, ASTNode node, AnnotationHolder holder, PropertiesHighlighter highlighter) {
        Lexer lexer = highlighter.getHighlightingLexer();
        String s = node.getText();
        lexer.start((CharSequence)s);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            IElementType elementType = lexer.getTokenType();
            for (TextAttributesKey key : keys = highlighter.getTokenHighlights(elementType)) {
                String displayName = PropertiesHighlighter.PropertiesComponent.getDisplayName(key);
                HighlightSeverity severity = PropertiesHighlighter.PropertiesComponent.getSeverity(key);
                if (severity == null || displayName == null) continue;
                int start = lexer.getTokenStart() + node.getTextRange().getStartOffset();
                int end = lexer.getTokenEnd() + node.getTextRange().getStartOffset();
                TextRange textRange = new TextRange(start, end);
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
                AnnotationBuilder builder = holder.newAnnotation(severity, displayName).range(textRange).enforcedTextAttributes(attributes);
                final int startOffset = textRange.getStartOffset();
                if (key == PropertiesHighlighter.PropertiesComponent.PROPERTIES_INVALID_STRING_ESCAPE.getTextAttributesKey()) {
                    builder = builder.withFix(new IntentionAction(){

                        @NotNull
                        public String getText() {
                            String string = PropertiesBundle.message("unescape", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        @NotNull
                        public String getFamilyName() {
                            String string = this.getText();
                            if (string == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }

                        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                            if (project == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (!BaseIntentionAction.canModify((PsiElement)file)) {
                                return false;
                            }
                            String text = file.getText();
                            return text.length() > startOffset && text.charAt(startOffset) == '\\';
                        }

                        public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
                            if (project == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            if (file.getText().charAt(startOffset) == '\\') {
                                editor.getDocument().deleteString(startOffset, startOffset + 1);
                            }
                        }

                        public boolean startInWriteAction() {
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 2;
                                case 2, 3 -> 3;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/lang/properties/PropertiesAnnotator$1";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getText";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getFamilyName";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/lang/properties/PropertiesAnnotator$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "isAvailable";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "invoke";
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalStateException(string);
                                case 2, 3 -> new IllegalArgumentException(string);
                            };
                        }
                    });
                }
                builder.create();
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/PropertiesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

