/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyPropertyValueToClipboardIntention
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            CopyPropertyValueToClipboardIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PropertiesBundle.message("copy.property.value.to.clipboard.intention.family.name", new Object[0]);
        if (string == null) {
            CopyPropertyValueToClipboardIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CopyPropertyValueToClipboardIntention.$$$reportNull$$$0(2);
        }
        return file.getLanguage().isKindOf((Language)PropertiesLanguage.INSTANCE) && CopyPropertyValueToClipboardIntention.getProperty(editor, file) != null;
    }

    @Nullable
    static Property getProperty(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        return (Property)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), Property.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Property property;
        if (project == null) {
            CopyPropertyValueToClipboardIntention.$$$reportNull$$$0(3);
        }
        if ((property = CopyPropertyValueToClipboardIntention.getProperty(editor, file)) == null) {
            return;
        }
        String value = property.getUnescapedValue();
        if (value == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(value));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/actions/CopyPropertyValueToClipboardIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/actions/CopyPropertyValueToClipboardIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

