/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmValue;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.CreatePropertyActionGroup;
import com.intellij.lang.jvm.actions.CreateReadOnlyPropertyActionGroup;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.lang.jvm.actions.JvmGroupIntentionAction;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateMemberAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000fH\u0016J%\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J$\u0010%\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateMemberAction;", "Lcom/intellij/lang/jvm/actions/JvmGroupIntentionAction;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "readOnly", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateMethodRequest;Z)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "propertyInfo", "Lkotlin/Pair;", "", "Lcom/intellij/lang/java/beans/PropertyKind;", "getPropertyInfo", "()Lkotlin/Pair;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "counterPart", "propertyKind", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getFamilyName", "getRenderData", "Lcom/intellij/lang/jvm/actions/JvmActionGroup$RenderData;", "getText", "invoke", "", "isAvailable", "PropertyRequest", "intellij.groovy"})
public final class CreatePropertyAction
extends CreateMemberAction
implements JvmGroupIntentionAction {
    @NotNull
    private final CreateMethodRequest request;
    private final boolean readOnly;
    @NotNull
    private final Project project;

    public CreatePropertyAction(@NotNull GrTypeDefinition target, @NotNull CreateMethodRequest request, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(target, (ActionRequest)request);
        this.request = request;
        this.readOnly = readOnly;
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
        this.project = project;
    }

    @NotNull
    protected CreateMethodRequest getRequest() {
        return this.request;
    }

    private final Pair<String, PropertyKind> getPropertyInfo() {
        String string = this.getRequest().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.methodName");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return pair;
    }

    @NotNull
    public JvmActionGroup.RenderData getRenderData() {
        return () -> CreatePropertyAction.getRenderData$lambda$0(this);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"create.property.from.usage.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"create.property.from.usage.family\")");
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new CreateFieldAction(this.getTarget(), new PropertyRequest(), false).generatePreview(project, editor, file);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        String string = this.getRequest().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.methodName");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            return false;
        }
        Pair<String, PropertyKind> pair2 = pair;
        String propertyName = (String)pair2.component1();
        PropertyKind propertyKind = (PropertyKind)pair2.component2();
        if (propertyKind == PropertyKind.SETTER && this.readOnly) {
            return false;
        }
        List list = this.getRequest().getExpectedParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.expectedParameters");
        List parameters2 = list;
        switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1: 
            case 2: {
                if (!(!((Collection)parameters2).isEmpty())) break;
                return false;
            }
            case 3: {
                if (parameters2.size() == 1) break;
                return false;
            }
        }
        String counterAccessorName = PropertyUtilKt.getAccessorName(this.counterPart(propertyKind), propertyName);
        PsiMethod[] psiMethodArray = this.getTarget().findMethodsByName(counterAccessorName, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"target.findMethodsByName\u2026unterAccessorName, false)");
        return ((Object[])psiMethodArray).length == 0;
    }

    private final PropertyKind counterPart(PropertyKind propertyKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1, 2 -> PropertyKind.SETTER;
            case 3 -> {
                List v1 = this.getRequest().getExpectedParameters();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"request.expectedParameters");
                List v2 = ((ExpectedParameter)CollectionsKt.single((List)v1)).getExpectedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"request.expectedParameters.single().expectedTypes");
                ExpectedType expectedType = (ExpectedType)CollectionsKt.singleOrNull((List)v2);
                if (expectedType != null && Intrinsics.areEqual((Object)PsiTypes.booleanType(), (Object)JvmPsiConversionHelper.getInstance((Project)this.project).convertType(expectedType.getTheType()))) {
                    yield PropertyKind.BOOLEAN_GETTER;
                }
                yield PropertyKind.GETTER;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getText() {
        String string;
        String propertyName = GroovyPropertyUtils.getPropertyNameByAccessorName(this.getRequest().getMethodName());
        String className = ClassPresentationUtil.getNameForClass((PsiClass)this.getTarget(), (boolean)false);
        if (this.readOnly) {
            Object[] objectArray = new Object[]{propertyName, className};
            String string2 = QuickFixBundle.message((String)"create.read.only.property.from.usage.full.text", (Object[])objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      message(\"create.\u2026rtyName, className)\n    }");
        } else {
            Object[] objectArray = new Object[]{propertyName, className};
            String string3 = QuickFixBundle.message((String)"create.property.from.usage.full.text", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n      message(\"create.\u2026rtyName, className)\n    }");
        }
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        CreateFieldAction createFieldAction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CreateFieldAction $this$invoke_u24lambda_u241 = createFieldAction = new CreateFieldAction(this.getTarget(), new PropertyRequest(), false);
        boolean bl = false;
        if ($this$invoke_u24lambda_u241.isAvailable(project, editor, file)) {
            $this$invoke_u24lambda_u241.invoke(project, editor, file);
        }
    }

    @NotNull
    public JvmActionGroup getActionGroup() {
        return this.readOnly ? (JvmActionGroup)CreateReadOnlyPropertyActionGroup.INSTANCE : (JvmActionGroup)CreatePropertyActionGroup.INSTANCE;
    }

    private static final String getRenderData$lambda$0(CreatePropertyAction this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (String)this$0.getPropertyInfo().getFirst();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0016J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction$PropertyRequest;", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;)V", "getAnnotations", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "getFieldName", "", "getFieldType", "", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "getInitializer", "Lcom/intellij/lang/jvm/JvmValue;", "getModifiers", "Lcom/intellij/lang/jvm/JvmModifier;", "getTargetSubstitutor", "Lcom/intellij/lang/jvm/types/JvmSubstitutor;", "Lorg/jetbrains/annotations/NotNull;", "isConstant", "", "isValid", "intellij.groovy"})
    public final class PropertyRequest
    implements CreateFieldRequest {
        public boolean isValid() {
            return true;
        }

        @NotNull
        public Collection<AnnotationRequest> getAnnotations() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<JvmModifier> getModifiers() {
            return CreatePropertyAction.this.readOnly ? CollectionsKt.listOf((Object)JvmModifier.FINAL) : CollectionsKt.emptyList();
        }

        @NotNull
        public String getFieldName() {
            return (String)CreatePropertyAction.this.getPropertyInfo().getFirst();
        }

        @NotNull
        public List<ExpectedType> getFieldType() {
            return JvmPsiUtilKt.createPropertyTypeConstraints(CreatePropertyAction.this.getRequest(), (PropertyKind)CreatePropertyAction.this.getPropertyInfo().getSecond());
        }

        @NotNull
        public JvmSubstitutor getTargetSubstitutor() {
            JvmSubstitutor jvmSubstitutor = CreatePropertyAction.this.getRequest().getTargetSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)jvmSubstitutor, (String)"request.targetSubstitutor");
            return jvmSubstitutor;
        }

        public boolean isConstant() {
            return false;
        }

        @Nullable
        public JvmValue getInitializer() {
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyKind.values().length];
            try {
                nArray[PropertyKind.GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.BOOLEAN_GETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.SETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

