/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAssignmentCanBeOperatorAssignmentInspection
extends BaseInspection {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)infos[0];
        String string = GroovyBundle.message("inspection.message.assignment.replaceable.with.operator.assignment", GroovyAssignmentCanBeOperatorAssignmentInspection.calculateReplacementExpression(assignmentExpression));
        if (string == null) {
            GroovyAssignmentCanBeOperatorAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreLazyOperators", (String)GroovyBundle.message("checkbox.ignore.conditional.operators", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreObscureOperators", (String)GroovyBundle.message("checkbox.ignore.obscure.operators", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GroovyAssignmentCanBeOperatorAssignmentInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    static String calculateReplacementExpression(GrAssignmentExpression expression) {
        GrExpression rhs = expression.getRValue();
        GrBinaryExpression binaryExpression = (GrBinaryExpression)PsiUtil.skipParentheses(rhs, false);
        GrExpression lhs = expression.getLValue();
        assert (binaryExpression != null);
        IElementType sign = binaryExpression.getOperationTokenType();
        GrExpression rhsRhs = binaryExpression.getRightOperand();
        assert (rhsRhs != null);
        String signText = GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(sign);
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        return lhs.getText() + " " + signText + "= " + rhsRhs.getText();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyAssignmentCanBeOperatorAssignmentInspection.$$$reportNull$$$0(2);
        }
        return new ReplaceAssignmentWithOperatorAssignmentFix((GrAssignmentExpression)location);
    }

    @Nullable
    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (operator == null) {
            return null;
        }
        if (operator.equals(GroovyTokenTypes.mPLUS)) {
            return "+";
        }
        if (operator.equals(GroovyTokenTypes.mMINUS)) {
            return "-";
        }
        if (operator.equals(GroovyTokenTypes.mSTAR)) {
            return "*";
        }
        if (operator.equals(GroovyTokenTypes.mDIV)) {
            return "/";
        }
        if (operator.equals(GroovyTokenTypes.mMOD)) {
            return "%";
        }
        if (operator.equals(GroovyTokenTypes.mBXOR)) {
            return "^";
        }
        if (operator.equals(GroovyTokenTypes.mLAND)) {
            return "&&";
        }
        if (operator.equals(GroovyTokenTypes.mLOR)) {
            return "||";
        }
        if (operator.equals(GroovyTokenTypes.mBAND)) {
            return "&";
        }
        if (operator.equals(GroovyTokenTypes.mBOR)) {
            return "|";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            if (assignment == null) {
                ReplaceAssignmentWithOperatorAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            if (assignment.isOperatorAssignment()) {
                return;
            }
            GrExpression lhs = assignment.getLValue();
            GrExpression rhs = (GrExpression)PsiUtil.skipParentheses(assignment.getRValue(), false);
            if (!(rhs instanceof GrBinaryExpression)) {
                return;
            }
            GrBinaryExpression binaryRhs = (GrBinaryExpression)rhs;
            if (binaryRhs.getRightOperand() == null) {
                return;
            }
            IElementType expressionTokenType = binaryRhs.getOperationTokenType();
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(expressionTokenType) == null) {
                return;
            }
            if (JavaTokenType.EQEQ.equals(expressionTokenType)) {
                return;
            }
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.this.ignoreLazyOperators && (GroovyTokenTypes.mLAND.equals(expressionTokenType) || GroovyTokenTypes.mLOR.equals(expressionTokenType))) {
                return;
            }
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.this.ignoreObscureOperators && (GroovyTokenTypes.mBXOR.equals(expressionTokenType) || GroovyTokenTypes.mMOD.equals(expressionTokenType))) {
                return;
            }
            GrExpression lOperand = binaryRhs.getLeftOperand();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(lhs, lOperand)) {
                return;
            }
            this.registerError((PsiElement)assignment, assignment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitAssignmentExpression"));
        }
    }

    private static final class ReplaceAssignmentWithOperatorAssignmentFix
    extends GroovyFix {
        @IntentionName
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(GrAssignmentExpression expression) {
            GrExpression rhs = expression.getRValue();
            GrBinaryExpression binaryExpression = (GrBinaryExpression)PsiUtil.skipParentheses(rhs, false);
            assert (binaryExpression != null);
            IElementType sign = binaryExpression.getOperationTokenType();
            String signText = GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(sign);
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = GroovyBundle.message("intention.name.replace.eq.with.0.eq", signText);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.simplify", new Object[0]);
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof GrAssignmentExpression)) {
                return;
            }
            GrAssignmentExpression expression = (GrAssignmentExpression)element;
            String newExpression = GroovyAssignmentCanBeOperatorAssignmentInspection.calculateReplacementExpression(expression);
            ReplaceAssignmentWithOperatorAssignmentFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

