/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.naming.NewClassNamingConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class NewGroovyClassNamingConventionInspection
extends AbstractNamingConventionInspection<PsiClass> {
    @NonNls
    private static final String GROOVY = "Groovy";

    public NewGroovyClassNamingConventionInspection() {
        super((Iterable)NewClassNamingConventionInspection.EP_NAME.getExtensionList(), "GroovyClassNamingConvention");
        this.registerConventionsListener(NewClassNamingConventionInspection.EP_NAME);
    }

    private static NamingConvention<PsiClass> wrapClassExtension(final NamingConvention<PsiClass> ex) {
        return new NamingConvention<PsiClass>(){

            public boolean isApplicable(PsiClass member) {
                return ex.isApplicable((PsiNameIdentifierOwner)member);
            }

            public String getElementDescription() {
                return ex.getElementDescription();
            }

            public String getShortName() {
                String shortName = ex.getShortName();
                if (shortName.startsWith("JUnit")) {
                    return shortName;
                }
                return NewGroovyClassNamingConventionInspection.GROOVY + (shortName.startsWith("Enum") ? "EnumerationNamingConvention" : shortName);
            }

            public NamingConventionBean createDefaultBean() {
                return ex.createDefaultBean();
            }
        };
    }

    protected void registerConvention(NamingConvention<PsiClass> convention) {
        super.registerConvention(NewGroovyClassNamingConventionInspection.wrapClassExtension(convention));
    }

    protected void unregisterConvention(@NotNull NamingConvention<PsiClass> extension) {
        if (extension == null) {
            NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(0);
        }
        super.unregisterConvention(NewGroovyClassNamingConventionInspection.wrapClassExtension(extension));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(1);
        }
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NewGroovyClassNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof GrTypeDefinition) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        return;
                    }
                    NewGroovyClassNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)aClass, name, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/naming/NewGroovyClassNamingConventionInspection$2", "visitElement"));
            }
        };
    }

    protected LocalQuickFix createRenameFix() {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/NewGroovyClassNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/NewGroovyClassNamingConventionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterConvention";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

