/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyWhileLoopSpinsOnFieldInspection
extends BaseInspection {
    public boolean ignoreNonEmtpyLoops = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GroovyBundle.message("inspection.message.ref.loop.spins.on.field", new Object[0]);
        if (string == null) {
            GroovyWhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonEmtpyLoops", (String)GroovyBundle.message("checkbox.only.warn.if.loop.empty", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GroovyWhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            if (statement == null) {
                WhileLoopSpinsOnFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (GroovyWhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops && !this.statementIsEmpty(body)) {
                return;
            }
            GrExpression condition = statement.getCondition();
            if (condition == null || !this.isSimpleFieldComparison(condition)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean isSimpleFieldComparison(GrExpression condition) {
            if ((condition = (GrExpression)PsiUtil.skipParentheses(condition, false)) == null) {
                return false;
            }
            if (this.isSimpleFieldAccess(condition)) {
                return true;
            }
            if (condition instanceof GrUnaryExpression) {
                GrUnaryExpression postfixExpression = (GrUnaryExpression)condition;
                if (((GrUnaryExpression)condition).isPostfix()) {
                    GrExpression operand = postfixExpression.getOperand();
                    return this.isSimpleFieldComparison(operand);
                }
            }
            if (condition instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)condition;
                GrExpression operand = unaryExpression.getOperand();
                return this.isSimpleFieldComparison(operand);
            }
            if (condition instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
                GrExpression lOperand = binaryExpression.getLeftOperand();
                GrExpression rOperand = binaryExpression.getRightOperand();
                if (this.isLiteral(rOperand)) {
                    return this.isSimpleFieldComparison(lOperand);
                }
                if (this.isLiteral(lOperand)) {
                    return this.isSimpleFieldComparison(rOperand);
                }
                return false;
            }
            return false;
        }

        private boolean isLiteral(GrExpression expression) {
            if ((expression = (GrExpression)PsiUtil.skipParentheses(expression, false)) == null) {
                return false;
            }
            return expression instanceof PsiLiteralExpression;
        }

        private boolean isSimpleFieldAccess(GrExpression expression) {
            if ((expression = (GrExpression)PsiUtil.skipParentheses(expression, false)) == null) {
                return false;
            }
            if (!(expression instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression reference = (GrReferenceExpression)expression;
            GrExpression qualifierExpression = reference.getQualifierExpression();
            if (qualifierExpression != null) {
                return false;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)referent;
            return !field.hasModifierProperty("volatile");
        }

        private boolean statementIsEmpty(GrStatement statement) {
            if (statement == null) {
                return false;
            }
            if (statement instanceof GrBlockStatement) {
                GrStatement[] codeBlockStatements;
                GrBlockStatement blockStatement = (GrBlockStatement)statement;
                GrOpenBlock codeBlock = blockStatement.getBlock();
                for (GrStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                    if (this.statementIsEmpty(codeBlockStatement)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor", "visitWhileStatement"));
        }
    }
}

