/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger.fragments;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.RegularImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.GroovyImportCollector;

public class GroovyCodeFragment
extends GroovyFileImpl
implements JavaCodeFragment,
IntentionFilterOwner,
GrUnAmbiguousClosureContainer {
    private static final Logger LOG = Logger.getInstance(GroovyCodeFragment.class);
    private PsiType myThisType;
    private PsiType mySuperType;
    private JavaCodeFragment.ExceptionHandler myExceptionChecker;
    private IntentionFilterOwner.IntentionActionsFilter myFilter;
    private GlobalSearchScope myResolveScope;
    private final GroovyImportCollector myImportCollector = new GroovyImportCollector(this);
    private final ClearableLazyValue<GroovyFileImports> myFileImports = ClearableLazyValue.create(() -> this.myImportCollector.build());
    private FileViewProvider myViewProvider = null;

    public GroovyCodeFragment(Project project, CharSequence text) {
        this(project, (VirtualFile)new LightVirtualFile("Dummy.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, text));
    }

    public GroovyCodeFragment(Project project, VirtualFile virtualFile) {
        super((FileViewProvider)new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), virtualFile, true));
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
    }

    public void setThisType(PsiType thisType) {
        this.myThisType = thisType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                GroovyCodeFragment.$$$reportNull$$$0(0);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            GroovyCodeFragment.$$$reportNull$$$0(1);
        }
        return fileViewProvider;
    }

    public String importsToString() {
        if (this.myImportCollector.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (GroovyImport anImport : this.myImportCollector.getAllImports()) {
            if (anImport instanceof RegularImport) {
                buffer.append(((RegularImport)anImport).getClassFqn()).append(':').append(((RegularImport)anImport).getName());
            } else if (anImport instanceof StaticImport) {
                buffer.append(((StaticImport)anImport).getClassFqn()).append('.').append(((StaticImport)anImport).getMemberName()).append(':').append(((StaticImport)anImport).getName());
            } else if (anImport instanceof GroovyStarImport) {
                buffer.append(((GroovyStarImport)anImport).getFqn());
            } else {
                LOG.warn("Unsupported import. Class: " + anImport.getClass());
            }
            buffer.append(',');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public void addImportsFromString(String imports2) {
        this.myFileImports.drop();
        for (String anImport : imports2.split(",")) {
            this.addImport(anImport);
        }
    }

    private void addImport(@NotNull String importString) {
        int colon;
        if (importString == null) {
            GroovyCodeFragment.$$$reportNull$$$0(2);
        }
        if ((colon = importString.indexOf(58)) >= 0) {
            boolean isStatic;
            String qname = importString.substring(0, colon);
            String importedName = importString.substring(colon + 1);
            boolean bl = isStatic = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qname, this.getResolveScope()) == null;
            if (isStatic) {
                this.myImportCollector.addStaticImport(StringUtil.getPackageName((String)qname), StringUtil.getShortName((String)qname), importedName);
            } else {
                this.myImportCollector.addRegularImport(qname, importedName);
            }
        } else {
            boolean isStatic;
            boolean bl = isStatic = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(importString, this.getResolveScope()) != null;
            if (isStatic) {
                this.myImportCollector.addStaticStarImport(importString);
            } else {
                this.myImportCollector.addStarImport(importString);
            }
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE;
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler checker) {
        this.myExceptionChecker = checker;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionChecker;
    }

    public void setIntentionActionsFilter(@NotNull IntentionFilterOwner.IntentionActionsFilter filter2) {
        if (filter2 == null) {
            GroovyCodeFragment.$$$reportNull$$$0(3);
        }
        this.myFilter = filter2;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyCodeFragment.$$$reportNull$$$0(4);
        }
        return false;
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyCodeFragment clone = (GroovyCodeFragment)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myOriginalFile = this;
        clone.myImportCollector.setFrom(this.myImportCollector);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    public void clearImports() {
        this.myFileImports.drop();
        this.myImportCollector.clear();
    }

    @Override
    @NotNull
    public GroovyFileImports getImports() {
        GroovyFileImports groovyFileImports = (GroovyFileImports)this.myFileImports.getValue();
        if (groovyFileImports == null) {
            GroovyCodeFragment.$$$reportNull$$$0(5);
        }
        return groovyFileImports;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIntentionActionsFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

