/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class SpockPomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, @NotNull Consumer<? super PomTarget> consumer) {
        String name;
        if (element == null) {
            SpockPomDeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SpockPomDeclarationSearcher.$$$reportNull$$$0(1);
        }
        if ((name = SpockUtils.getNameByReference(element)) == null) {
            return;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"spock.lang.Specification")) {
            return;
        }
        Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
        SpockVariableDescriptor descriptor2 = cachedValue.get(name);
        if (descriptor2 == null) {
            return;
        }
        if (descriptor2.getNavigationElement() == element) {
            consumer.consume((Object)descriptor2.getVariable());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockPomDeclarationSearcher";
        objectArray[2] = "findDeclarationsAt";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

