/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;
import org.jetbrains.plugins.groovy.gant.GantUtils;

public class GantLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GANT_KIND = LibraryKind.create((String)"gant");

    public GantLibraryPresentationProvider() {
        super(GANT_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GantUtils.isGantLibrary(libraryFiles);
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        String version = GantUtils.getGantVersionOrNull(GantUtils.getGantLibraryHome(libraryFiles));
        return version == null ? GroovyBundle.message("undefined.library.version", new Object[0]) : version;
    }

    @Override
    @NotNull
    public Icon getIcon(GroovyLibraryProperties properties) {
        Icon icon = JetgroovyIcons.Groovy.Gant_sdk;
        if (icon == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(1);
        }
        return GantUtils.isGantSdkHome(file);
    }

    @Override
    @Nullable
    public String getSDKVersion(String path) {
        return GantUtils.getGantVersionOrNull(path);
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        String string = GroovyBundle.message("framework.gant", new Object[0]);
        if (string == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File lib;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        File[] fileArray = jars = (lib = new File(path + "/lib")).exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCategoryName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSDKHome";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

