/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ReplaceIfWithTernaryIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrConditionalExpression conditional;
        if (element == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(1);
        }
        GrIfStatement ifStatement = (GrIfStatement)element.getParent();
        PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
        PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
        if (thenBranch instanceof GrAssignmentExpression && elseBranch instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(project).createStatementFromText("a = b ? c : d");
            assignment.getLValue().replaceWithExpression(((GrAssignmentExpression)thenBranch).getLValue(), true);
            conditional = (GrConditionalExpression)assignment.getRValue();
            ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), ((GrAssignmentExpression)thenBranch).getRValue(), ((GrAssignmentExpression)elseBranch).getRValue());
            ifStatement.replaceWithStatement(assignment);
        }
        if (thenBranch instanceof GrReturnStatement && elseBranch instanceof GrReturnStatement) {
            GrReturnStatement returnSt = (GrReturnStatement)GroovyPsiElementFactory.getInstance(project).createStatementFromText("return a ? b : c");
            conditional = (GrConditionalExpression)returnSt.getReturnValue();
            ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), ((GrReturnStatement)thenBranch).getReturnValue(), ((GrReturnStatement)elseBranch).getReturnValue());
            ifStatement.replaceWithStatement(returnSt);
        }
    }

    private static void replaceConditional(GrConditionalExpression conditional, GrExpression condition, GrExpression then, GrExpression elze) {
        conditional.getCondition().replaceWithExpression(condition, true);
        conditional.getThenBranch().replaceWithExpression(then, true);
        conditional.getElseBranch().replaceWithExpression(elze, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!e.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                    return false;
                }
                PsiElement psiElement = e.getParent();
                if (!(psiElement instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)psiElement;
                PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
                PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
                if (thenBranch instanceof GrAssignmentExpression && elseBranch instanceof GrAssignmentExpression && ((GrAssignmentExpression)thenBranch).getRValue() != null && ((GrAssignmentExpression)elseBranch).getRValue() != null) {
                    GrExpression lvalue1 = ((GrAssignmentExpression)thenBranch).getLValue();
                    GrExpression lvalue2 = ((GrAssignmentExpression)elseBranch).getLValue();
                    return EquivalenceChecker.expressionsAreEquivalent(lvalue1, lvalue2);
                }
                return thenBranch instanceof GrReturnStatement && elseBranch instanceof GrReturnStatement && ((GrReturnStatement)thenBranch).getReturnValue() != null && ((GrReturnStatement)elseBranch).getReturnValue() != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/intentions/control/ReplaceIfWithTernaryIntention$1", "satisfiedBy"));
            }
        };
    }

    private static PsiElement skipBlock(PsiElement e) {
        if (e instanceof GrBlockStatement && ((GrBlockStatement)e).getBlock().getStatements().length == 1) {
            return ((GrBlockStatement)e).getBlock().getStatements()[0];
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/control/ReplaceIfWithTernaryIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

