/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

class IndexedExpressionConversionPredicate
implements PsiElementPredicate {
    IndexedExpressionConversionPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            IndexedExpressionConversionPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrIndexProperty)) {
            return false;
        }
        GrIndexProperty arrayIndexExpression = (GrIndexProperty)element;
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiElement lastChild = arrayIndexExpression.getLastChild();
        if (!(lastChild instanceof GrArgumentList)) {
            return false;
        }
        GrArgumentList argList = (GrArgumentList)lastChild;
        GrExpression[] arguments2 = argList.getExpressionArguments();
        if (arguments2.length != 1) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrAssignmentExpression)) {
            return true;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent2;
        GrExpression rvalue = assignmentExpression.getRValue();
        if (rvalue == null) {
            return false;
        }
        if (rvalue.equals(element)) {
            return true;
        }
        return !assignmentExpression.isOperatorAssignment();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/IndexedExpressionConversionPredicate", "satisfiedBy"));
    }
}

