/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public final class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance(GroovyPsiManager.class);
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    @NotNull
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass;
    private static final RecursionGuard<PsiElement> ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");

    public GroovyPsiManager(@NotNull Project project) {
        if (project == null) {
            GroovyPsiManager.$$$reportNull$$$0(0);
        }
        this.myArrayClass = new HashMap<String, GrTypeDefinition>();
        this.myProject = project;
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)project.getService(GroovyPsiManager.class);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        PsiClass result2;
        if (fqName == null) {
            GroovyPsiManager.$$$reportNull$$$0(1);
        }
        if (resolveScope == null) {
            GroovyPsiManager.$$$reportNull$$$0(2);
        }
        if (ourPopularClasses.contains(fqName) && (result2 = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope)) != null) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result2);
            if (psiClassType == null) {
                GroovyPsiManager.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
        if (psiClassType == null) {
            GroovyPsiManager.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    @Nullable
    public GrTypeDefinition getArrayClass(@NotNull PsiType type2) {
        String typeText;
        GrTypeDefinition definition;
        if (type2 == null) {
            GroovyPsiManager.$$$reportNull$$$0(5);
        }
        if ((definition = this.myArrayClass.get(typeText = type2.getCanonicalText())) == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    @Nullable
    public static PsiType inferType(@NotNull PsiElement element, @NotNull Computable<? extends PsiType> computable) {
        List stack;
        if (element == null) {
            GroovyPsiManager.$$$reportNull$$$0(6);
        }
        if (computable == null) {
            GroovyPsiManager.$$$reportNull$$$0(7);
        }
        if ((stack = ourGuard.currentStack()).size() > 7) {
            ourGuard.prohibitResultCaching((Object)((PsiElement)stack.get(0)));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArrayClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

