/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.contributor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.contributor.AbstractGeneratedConstructorContributor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/SyntheticKeywordConstructorContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/AbstractGeneratedConstructorContributor;", "()V", "createSyntheticConstructors", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "failFastCheck", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "generateSyntheticElements", "", "Lcom/intellij/psi/PsiElement;", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "mode", "", "Companion", "SyntheticKeywordConstructor", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nSyntheticKeywordConstructorContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticKeywordConstructorContributor.kt\norg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/SyntheticKeywordConstructorContributor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,79:1\n57#2,2:80\n*S KotlinDebug\n*F\n+ 1 SyntheticKeywordConstructorContributor.kt\norg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/SyntheticKeywordConstructorContributor\n*L\n40#1:80,2\n*E\n"})
public final class SyntheticKeywordConstructorContributor
extends AbstractGeneratedConstructorContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean failFastCheck(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        String nameHint = ResolveUtil.getNameHint(processor);
        return nameHint != null && !Intrinsics.areEqual((Object)nameHint, (Object)"super");
    }

    @Override
    @NotNull
    public Iterable<PsiElement> generateSyntheticElements(@NotNull PsiAnnotation annotation, @NotNull GrClosableBlock closure, @NotNull String mode) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return Intrinsics.areEqual((Object)mode, (Object)"pre") ? (Iterable)this.createSyntheticConstructors(closure) : (Iterable)CollectionsKt.emptyList();
    }

    private final List<GrMethod> createSyntheticConstructors(GrClosableBlock closure) {
        PsiElement $this$parentOfType_u24default$iv = closure;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiClass.class, (boolean)true);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass outerClass = psiClass;
        PsiClass superClass = outerClass.getSuperClass();
        SmartList methods = new SmartList();
        if (superClass != null) {
            PsiMethod[] psiMethodArray = superClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"superClass.constructors");
            PsiMethod[] constructors = psiMethodArray;
            if (constructors.length == 0) {
                SyntheticKeywordConstructor method = new SyntheticKeywordConstructor(outerClass, superClass, "super");
                methods.add((Object)method);
            } else {
                for (PsiMethod constructor : constructors) {
                    PsiParameter[] psiParameterArray;
                    SyntheticKeywordConstructor method = new SyntheticKeywordConstructor(outerClass, superClass, "super");
                    Intrinsics.checkNotNullExpressionValue((Object)constructor.getParameterList().getParameters(), (String)"constructor.parameterList.parameters");
                    for (PsiParameter param : psiParameterArray) {
                        method.addParameter(param.getName(), param.getType());
                    }
                    methods.add((Object)method);
                }
            }
        }
        return (List)methods;
    }

    @JvmStatic
    public static final boolean isSyntheticConstructorCall(@Nullable GrMethodCall call) {
        return Companion.isSyntheticConstructorCall(call);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u0004*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/SyntheticKeywordConstructorContributor$Companion;", "", "()V", "isSyntheticConstructorCall", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "isReserved", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isReserved(String $this$isReserved) {
            return Intrinsics.areEqual((Object)$this$isReserved, (Object)"super");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isSyntheticConstructorCall(@Nullable GrMethodCall call) {
            Object object = call;
            if (!this.isReserved(object != null && (object = object.getCallReference()) != null ? object.getMethodName() : null)) return false;
            GrMethodCall grMethodCall = call;
            if (!((grMethodCall != null ? grMethodCall.resolveMethod() : null) instanceof SyntheticKeywordConstructor)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/ast/contributor/SyntheticKeywordConstructorContributor$SyntheticKeywordConstructor;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightMethodBuilder;", "containingClass", "Lcom/intellij/psi/PsiClass;", "superClass", "name", "", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/psi/PsiClass;Ljava/lang/String;)V", "intellij.groovy.psi"})
    private static final class SyntheticKeywordConstructor
    extends GrLightMethodBuilder {
        public SyntheticKeywordConstructor(@NotNull PsiClass containingClass, @NotNull PsiClass superClass, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(containingClass.getManager(), name);
            boolean bl = Companion.isReserved(name);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.setConstructor(true);
            this.setNavigationElement((PsiElement)superClass);
            this.setContainingClass(containingClass);
        }
    }
}

