/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrMemberInfo
extends MemberInfoBase<GrMember> {
    private final GrReferenceList mySourceReferenceList;

    public GrMemberInfo(GrMember member) {
        this(member, false, null);
    }

    public GrMemberInfo(GrMember member, boolean isSuperClass, GrReferenceList sourceReferenceList) {
        super((PsiElement)member);
        LOG.assertTrue(member.isValid());
        this.mySourceReferenceList = sourceReferenceList;
        if (member instanceof GrMethod) {
            GrMethod method = (GrMethod)member;
            this.displayName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)7);
            PsiMethod[] superMethods = method.findSuperMethods();
            this.overrides = superMethods.length > 0 ? Boolean.valueOf(!superMethods[0].hasModifierProperty("abstract")) : null;
            this.isStatic = method.hasModifierProperty("static");
        } else if (member instanceof GrField) {
            GrField field = (GrField)member;
            this.displayName = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.isStatic = field.hasModifierProperty("static");
            this.overrides = null;
        } else if (member instanceof GrTypeDefinition) {
            GrTypeDefinition aClass = (GrTypeDefinition)member;
            if (isSuperClass) {
                if (aClass.isInterface()) {
                    this.displayName = RefactoringBundle.message((String)"member.info.implements.0", (Object[])new Object[]{aClass.getName()});
                    this.overrides = Boolean.FALSE;
                } else {
                    this.displayName = RefactoringBundle.message((String)"member.info.extends.0", (Object[])new Object[]{aClass.getName()});
                    this.overrides = Boolean.TRUE;
                }
            } else {
                this.displayName = aClass.getName();
                this.overrides = null;
            }
            this.isStatic = aClass.hasModifierProperty("static");
        } else {
            LOG.assertTrue(false);
            this.isStatic = false;
            this.displayName = "";
            this.overrides = null;
        }
    }

    public GrReferenceList getSourceReferenceList() {
        return this.mySourceReferenceList;
    }

    public static List<GrMemberInfo> extractClassMembers(GrTypeDefinition subclass, MemberInfoBase.Filter<GrMember> filter2, boolean extractInterfacesDeep) {
        ArrayList<GrMemberInfo> members = new ArrayList<GrMemberInfo>();
        GrMemberInfo.extractClassMembers(subclass, members, filter2, extractInterfacesDeep);
        return members;
    }

    public static void extractClassMembers(PsiClass subclass, List<GrMemberInfo> result2, MemberInfoBase.Filter<GrMember> filter2, boolean extractInterfacesDeep) {
        GrField[] fields;
        GrMethod[] methods;
        PsiClass[] innerClasses;
        if (!(subclass instanceof GrTypeDefinition)) {
            return;
        }
        if (extractInterfacesDeep) {
            GrMemberInfo.extractSuperInterfaces(subclass, filter2, result2, new HashSet<PsiClass>());
        } else {
            PsiClass[] interfaces = subclass.getInterfaces();
            PsiClass[] sourceRefList = subclass.isInterface() ? ((GrTypeDefinition)subclass).getExtendsClause() : ((GrTypeDefinition)subclass).getImplementsClause();
            PsiClass[] psiClassArray = interfaces;
            int n = psiClassArray.length;
            for (int j = 0; j < n; ++j) {
                PsiClass anInterface = psiClassArray[j];
                if (!(anInterface instanceof GrTypeDefinition) || !filter2.includeMember((PsiElement)((GrMember)anInterface))) continue;
                result2.add(new GrMemberInfo((GrMember)anInterface, true, (GrReferenceList)sourceRefList));
            }
        }
        for (PsiClass innerClass : innerClasses = subclass.getInnerClasses()) {
            if (!(innerClass instanceof GrTypeDefinition) || !filter2.includeMember((PsiElement)((GrMember)innerClass))) continue;
            result2.add(new GrMemberInfo((GrMember)innerClass));
        }
        for (GrMethod method : methods = ((GrTypeDefinition)subclass).getCodeMethods()) {
            if (method.isConstructor() || !filter2.includeMember((PsiElement)method)) continue;
            result2.add(new GrMemberInfo(method));
        }
        for (GrField field : fields = ((GrTypeDefinition)subclass).getCodeFields()) {
            if (!filter2.includeMember((PsiElement)field)) continue;
            result2.add(new GrMemberInfo(field));
        }
    }

    private static void extractSuperInterfaces(PsiClass subclass, MemberInfoBase.Filter<GrMember> filter2, List<GrMemberInfo> result2, Set<PsiClass> processed) {
        if (!processed.contains(subclass)) {
            processed.add(subclass);
            if (subclass instanceof GrTypeDefinition) {
                GrMemberInfo.extractSuperInterfacesFromReferenceList(((GrTypeDefinition)subclass).getExtendsClause(), filter2, result2, processed);
                GrMemberInfo.extractSuperInterfacesFromReferenceList(((GrTypeDefinition)subclass).getImplementsClause(), filter2, result2, processed);
            }
        }
    }

    private static void extractSuperInterfacesFromReferenceList(GrReferenceList referenceList, MemberInfoBase.Filter<GrMember> filter2, List<GrMemberInfo> result2, Set<PsiClass> processed) {
        if (referenceList != null) {
            PsiClassType[] extendsListTypes;
            for (PsiClassType extendsListType : extendsListTypes = referenceList.getReferencedTypes()) {
                PsiClass aSuper = extendsListType.resolve();
                if (!(aSuper instanceof GrTypeDefinition)) continue;
                if (aSuper.isInterface()) {
                    if (!filter2.includeMember((PsiElement)((GrMember)aSuper))) continue;
                    result2.add(new GrMemberInfo((GrMember)aSuper, true, referenceList));
                    continue;
                }
                GrMemberInfo.extractSuperInterfaces(aSuper, filter2, result2, processed);
            }
        }
    }
}

