/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class BindableTransformationSupport
implements AstTransformationSupport {
    @NlsSafe
    private static final String BINDABLE_FQN = "groovy.beans.Bindable";
    @NlsSafe
    private static final String PCL_FQN = "java.beans.PropertyChangeListener";
    @NlsSafe
    private static final String PCS_FQN = "java.beans.PropertyChangeSupport";
    @NonNls
    public static final String ORIGIN_INFO = "via @Bindable";

    private static boolean isApplicable(@NotNull GrTypeDefinition clazz) {
        PsiAnnotation annotation;
        if (clazz == null) {
            BindableTransformationSupport.$$$reportNull$$$0(0);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (boolean)true, (String[])new String[]{BINDABLE_FQN})) != null) {
            return true;
        }
        for (GrField method : clazz.getCodeFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{BINDABLE_FQN}) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        GrTypeDefinition clazz;
        if (context == null) {
            BindableTransformationSupport.$$$reportNull$$$0(1);
        }
        if (!BindableTransformationSupport.isApplicable(clazz = context.getCodeClass())) {
            return;
        }
        PsiManager manager = clazz.getManager();
        GlobalSearchScope scope = clazz.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)clazz.getProject());
        PsiClassType pclType = facade.getElementFactory().createTypeByFQClassName(PCL_FQN, scope);
        PsiArrayType pclArrayType = new PsiArrayType((PsiType)pclType);
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)scope);
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
        ArrayList<LightMethodBuilder> methods = new ArrayList<LightMethodBuilder>();
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "addPropertyChangeListener").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "addPropertyChangeListener").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("name", (PsiType)stringType).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "removePropertyChangeListener").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "removePropertyChangeListener").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("name", (PsiType)stringType).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "firePropertyChange").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("name", (PsiType)stringType).addParameter("oldValue", (PsiType)objectType).addParameter("newValue", (PsiType)objectType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "getPropertyChangeListeners").setMethodReturnType((PsiType)pclArrayType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "getPropertyChangeListeners").setMethodReturnType((PsiType)pclArrayType).addParameter("name", (PsiType)stringType));
        for (LightMethodBuilder method : methods) {
            method.addModifier("public");
            method.setOriginInfo(ORIGIN_INFO);
            method.putUserData(ResolveUtil.DOCUMENTATION_DELEGATE_FQN, (Object)PCS_FQN);
        }
        context.addMethods(methods);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/impl/BindableTransformationSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTransformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

