/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class SwitchHelper {
    public static void simplifySwitchOnEnum(@NotNull SwitchStatement switchStatement) {
        ArrayExprent array;
        Map<Exprent, Exprent> mapping;
        SwitchExprent switchExprent;
        Exprent value;
        if (switchStatement == null) {
            SwitchHelper.$$$reportNull$$$0(0);
        }
        if (!SwitchHelper.isEnumArray(value = Objects.requireNonNull(switchExprent = (SwitchExprent)switchStatement.getHeadExprent()).getValue())) {
            return;
        }
        List<List<@Nullable Exprent>> caseValues = switchStatement.getCaseValues();
        List<List<@Nullable Exprent>> realCaseValues = SwitchHelper.findRealCaseValues(caseValues, mapping = SwitchHelper.evaluateCaseLabelsToFieldsMapping(caseValues, array = (ArrayExprent)value));
        if (realCaseValues == null) {
            return;
        }
        caseValues.clear();
        caseValues.addAll(realCaseValues);
        switchExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
    }

    public static void simplifySwitchesOnString(@NotNull RootStatement root) {
        if (root == null) {
            SwitchHelper.$$$reportNull$$$0(1);
        }
        ArrayList<SwitchOnStringCandidate> candidates = new ArrayList<SwitchOnStringCandidate>();
        SwitchHelper.collectSwitchesOnString(root, new ArrayList<SwitchRecognizer>(Arrays.asList(new SwitchRecognizer.JavacRecognizer(), new SwitchRecognizer.EcjRecognizer())), candidates);
        if (candidates.isEmpty()) {
            return;
        }
        HashMap<VarExprent, Statement> tempVarAssignments = new HashMap<VarExprent, Statement>();
        candidates.forEach(candidate -> candidate.simplify(tempVarAssignments));
        SwitchHelper.removeTempVariableDeclarations(tempVarAssignments);
    }

    private static void collectSwitchesOnString(@NotNull Statement statement, @NotNull List<SwitchRecognizer> recognizers, @NotNull List<SwitchOnStringCandidate> candidates) {
        SwitchStatement switchStatement;
        SwitchExprent switchExprent;
        Exprent switchSelector;
        if (statement == null) {
            SwitchHelper.$$$reportNull$$$0(2);
        }
        if (recognizers == null) {
            SwitchHelper.$$$reportNull$$$0(3);
        }
        if (candidates == null) {
            SwitchHelper.$$$reportNull$$$0(4);
        }
        if (statement instanceof SwitchStatement && (switchSelector = Objects.requireNonNull(switchExprent = (SwitchExprent)(switchStatement = (SwitchStatement)statement).getHeadExprent()).getValue()) instanceof InvocationExprent) {
            SwitchRecognizer usedRecognizer = null;
            for (SwitchRecognizer recognizer : recognizers) {
                SwitchOnStringCandidate switchCandidate = recognizer.recognize(switchStatement, (InvocationExprent)switchSelector);
                if (switchCandidate == null) continue;
                candidates.add(switchCandidate);
                usedRecognizer = recognizer;
                break;
            }
            if (usedRecognizer != null) {
                recognizers.retainAll(Collections.singletonList(usedRecognizer));
            }
        }
        for (Statement child : statement.getStats()) {
            SwitchHelper.collectSwitchesOnString(child, recognizers, candidates);
        }
    }

    @NotNull
    private static Map<Exprent, Exprent> evaluateCaseLabelsToFieldsMapping(@NotNull List<List<Exprent>> caseValues, @NotNull ArrayExprent array) {
        if (caseValues == null) {
            SwitchHelper.$$$reportNull$$$0(5);
        }
        if (array == null) {
            SwitchHelper.$$$reportNull$$$0(6);
        }
        HashMap<Exprent, Exprent> mapping = new HashMap<Exprent, Exprent>(caseValues.size());
        if (array.getArray().type == 5) {
            FieldExprent arrayField = (FieldExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
            if (classNode == null) {
                HashMap<Exprent, Exprent> hashMap = mapping;
                if (hashMap == null) {
                    SwitchHelper.$$$reportNull$$$0(7);
                }
                return hashMap;
            }
            MethodWrapper wrapper = classNode.getWrapper().getMethodWrapper("<clinit>", "()V");
            if (wrapper != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1 && ((ArrayExprent)left).getArray().equals(arrayField)) {
                            mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                        }
                    }
                    return 0;
                });
            }
        } else if (array.getArray().type == 8) {
            InvocationExprent invocationExprent = (InvocationExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invocationExprent.getClassName());
            if (classNode == null) {
                HashMap<Exprent, Exprent> hashMap = mapping;
                if (hashMap == null) {
                    SwitchHelper.$$$reportNull$$$0(8);
                }
                return hashMap;
            }
            MethodWrapper wrapper = classNode.getWrapper().getMethodWrapper(invocationExprent.getName(), "()[I");
            if (wrapper != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1) {
                            Exprent indexExprent = ((ArrayExprent)left).getIndex();
                            if (indexExprent.type == 8 && ((InvocationExprent)indexExprent).getName().equals("ordinal")) {
                                mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                            }
                        }
                    }
                    return 0;
                });
            }
        }
        HashMap<Exprent, Exprent> hashMap = mapping;
        if (hashMap == null) {
            SwitchHelper.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @Nullable
    private static @Nullable List<List<@Nullable Exprent>> findRealCaseValues(@NotNull List<List<Exprent>> caseValues, @NotNull Map<Exprent, Exprent> mapping) {
        if (caseValues == null) {
            SwitchHelper.$$$reportNull$$$0(10);
        }
        if (mapping == null) {
            SwitchHelper.$$$reportNull$$$0(11);
        }
        ArrayList<List<@Nullable Exprent>> result = new ArrayList<List<Exprent>>(caseValues.size());
        for (List<Exprent> caseValue : caseValues) {
            ArrayList<@Nullable Exprent> values = new ArrayList<Exprent>(caseValue.size());
            result.add(values);
            for (Exprent exprent : caseValue) {
                if (exprent == null) {
                    values.add(null);
                    continue;
                }
                Exprent realConst = mapping.get(exprent);
                if (realConst == null) {
                    DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + exprent + " not found, available: " + mapping, IFernflowerLogger.Severity.ERROR);
                    return null;
                }
                values.add(realConst.copy());
            }
        }
        return result;
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (!(exprent instanceof ArrayExprent)) {
            return false;
        }
        Exprent field = ((ArrayExprent)exprent).getArray();
        Exprent index = ((ArrayExprent)exprent).getIndex();
        boolean isJavacEnumArray = field instanceof FieldExprent && (((FieldExprent)field).getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal"));
        boolean isEclipseEnumArray = field instanceof InvocationExprent && ((InvocationExprent)field).getName().startsWith("$SWITCH_TABLE");
        return isJavacEnumArray || isEclipseEnumArray;
    }

    static void removeTempVariableDeclarations(@NotNull Map<VarExprent, Statement> tempVarAssignments) {
        if (tempVarAssignments == null) {
            SwitchHelper.$$$reportNull$$$0(12);
        }
        if (tempVarAssignments.isEmpty()) {
            return;
        }
        Iterator<Statement> iterator = new HashSet<Statement>(tempVarAssignments.values()).iterator();
        block0: while (iterator.hasNext()) {
            Statement statement;
            for (Statement parent = statement = iterator.next(); parent != null; parent = parent.getParent()) {
                boolean removed = false;
                List<Exprent> varExprents = parent.getFirst().type == Statement.StatementType.BASIC_BLOCK ? parent.getFirst().getExprents() : (parent.type == Statement.StatementType.TRY_CATCH ? parent.getVarDefinitions() : Collections.emptyList());
                for (int i = 0; i < varExprents.size(); ++i) {
                    VarExprent varExprent;
                    Exprent exprent = varExprents.get(i);
                    Exprent assignmentExprent = null;
                    if (exprent.type == 2) {
                        assignmentExprent = exprent;
                        exprent = ((AssignmentExprent)exprent).getLeft();
                    }
                    if (exprent.type != 12 || !(varExprent = (VarExprent)exprent).isDefinition() || !tempVarAssignments.keySet().stream().anyMatch(expr -> expr.getIndex() == varExprent.getIndex() && expr.getVersion() == varExprent.getVersion())) continue;
                    varExprents.remove(assignmentExprent == null ? varExprent : assignmentExprent);
                    removed = true;
                    break;
                }
                if (removed) continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recognizers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseValues";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempVarAssignments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateCaseLabelsToFieldsMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "simplifySwitchOnEnum";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "simplifySwitchesOnString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSwitchesOnString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCaseLabelsToFieldsMapping";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findRealCaseValues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTempVariableDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static abstract class SwitchRecognizer {
        private SwitchRecognizer() {
        }

        @Nullable
        abstract SwitchOnStringCandidate recognize(@NotNull SwitchStatement var1, @NotNull InvocationExprent var2);

        @NotNull
        Set<Object> findRealCaseValuesHashCodes(@NotNull SwitchStatement switchStatement) {
            if (switchStatement == null) {
                SwitchRecognizer.$$$reportNull$$$0(0);
            }
            Set<Object> set = switchStatement.getCaseValues().stream().filter(values -> values.stream().noneMatch(Objects::isNull)).flatMap(Collection::stream).map(value -> (ConstExprent)value).map(ConstExprent::getValue).collect(Collectors.toSet());
            if (set == null) {
                SwitchRecognizer.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Nullable
        String findRealCaseValue(@NotNull IfStatement ifStatement, @NotNull Exprent selectorQualifier) {
            if (ifStatement == null) {
                SwitchRecognizer.$$$reportNull$$$0(2);
            }
            if (selectorQualifier == null) {
                SwitchRecognizer.$$$reportNull$$$0(3);
            }
            Exprent ifCondition = ifStatement.getHeadexprent().getCondition();
            if (ifCondition.type != 8) {
                return null;
            }
            InvocationExprent invocationCondition = (InvocationExprent)ifCondition;
            if (!invocationCondition.isInstanceCall("java/lang/String", "equals", 1)) {
                return null;
            }
            if (!invocationCondition.getInstance().equals(selectorQualifier)) {
                return null;
            }
            Exprent equalsParameter = invocationCondition.getParameters().get(0);
            if (equalsParameter.type != 3) {
                return null;
            }
            Object caseLabelValue = ((ConstExprent)equalsParameter).getValue();
            return caseLabelValue instanceof String ? (String)caseLabelValue : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchRecognizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchRecognizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRealCaseValuesHashCodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findRealCaseValuesHashCodes";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findRealCaseValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        private static class EcjRecognizer
        extends SwitchRecognizer {
            private EcjRecognizer() {
            }

            @Override
            @Nullable
            public SwitchOnStringCandidate recognize(@NotNull SwitchStatement switchStatement, @NotNull InvocationExprent switchSelector) {
                if (switchStatement == null) {
                    EcjRecognizer.$$$reportNull$$$0(0);
                }
                if (switchSelector == null) {
                    EcjRecognizer.$$$reportNull$$$0(1);
                }
                if (!switchSelector.isInstanceCall("java/lang/String", "hashCode", 0)) {
                    return null;
                }
                Set<Object> realCaseValueHashCodes = this.findRealCaseValuesHashCodes(switchStatement);
                Exprent switchSelectorQualifier = switchSelector.getInstance();
                HashMap<Integer, String> mappedCaseLabelValues = new HashMap<Integer, String>();
                HashMap<Integer, IfStatement> ifBodyStatements = new HashMap<Integer, IfStatement>();
                VarExprent tempVar = null;
                for (Statement statement : switchStatement.getCaseStatements()) {
                    if (statement.type != Statement.StatementType.IF) {
                        Statement defaultStatement = switchStatement.getDefaultEdge().getDestination();
                        if (defaultStatement == statement) continue;
                        return null;
                    }
                    Exprent tempSwitchSelectorQualifier = switchSelectorQualifier;
                    if (switchSelectorQualifier.type == 2) {
                        tempSwitchSelectorQualifier = ((AssignmentExprent)switchSelectorQualifier).getLeft();
                    } else if (switchSelectorQualifier.type == 3) {
                        Exprent finalSwitchSelectorQualifier = switchSelectorQualifier;
                        tempSwitchSelectorQualifier = switchStatement.getFirst().getExprents().stream().filter(exprent -> exprent instanceof AssignmentExprent).map(exprent -> (AssignmentExprent)exprent).filter(exprent -> exprent.getRight().equals(finalSwitchSelectorQualifier)).map(AssignmentExprent::getLeft).findFirst().orElse(null);
                        if (tempSwitchSelectorQualifier == null) {
                            return null;
                        }
                    }
                    if (tempVar != null && !tempVar.equals(tempSwitchSelectorQualifier)) {
                        return null;
                    }
                    IfStatement ifStatement = (IfStatement)statement;
                    tempVar = (VarExprent)tempSwitchSelectorQualifier;
                    String caseLabelValue = this.findRealCaseValue(ifStatement, tempVar);
                    if (caseLabelValue == null) {
                        return null;
                    }
                    int caseLabelHash = caseLabelValue.hashCode();
                    if (!realCaseValueHashCodes.remove(caseLabelHash)) {
                        return null;
                    }
                    mappedCaseLabelValues.put(caseLabelHash, caseLabelValue);
                    ifBodyStatements.put(caseLabelHash, ifStatement);
                }
                if (tempVar == null || !realCaseValueHashCodes.isEmpty()) {
                    return null;
                }
                if (switchSelectorQualifier instanceof AssignmentExprent) {
                    switchSelectorQualifier = ((AssignmentExprent)switchSelectorQualifier).getRight();
                }
                return new SwitchOnStringCandidate.EcjSwitchCandidate(switchStatement, switchSelectorQualifier, tempVar, ifBodyStatements, mappedCaseLabelValues);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "switchStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "switchSelector";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchRecognizer$EcjRecognizer";
                objectArray[2] = "recognize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class JavacRecognizer
        extends SwitchRecognizer {
            private JavacRecognizer() {
            }

            @Override
            @Nullable
            public SwitchOnStringCandidate recognize(@NotNull SwitchStatement firstSwitch, @NotNull InvocationExprent switchSelector) {
                if (firstSwitch == null) {
                    JavacRecognizer.$$$reportNull$$$0(0);
                }
                if (switchSelector == null) {
                    JavacRecognizer.$$$reportNull$$$0(1);
                }
                if (switchSelector.getInstance().type != 12) {
                    return null;
                }
                if (!switchSelector.isInstanceCall("java/lang/String", "hashCode", 0)) {
                    return null;
                }
                Set<Object> realCaseValueHashCodes = this.findRealCaseValuesHashCodes(firstSwitch);
                VarExprent firstSwitchSelectorQualifier = (VarExprent)switchSelector.getInstance();
                VarExprent tmpVarAssignTo = null;
                SwitchStatement secondSwitch = null;
                HashMap<Integer, String> mappedCaseLabelValues = new HashMap<Integer, String>();
                for (Statement statement : firstSwitch.getCaseStatements()) {
                    if (statement.type != Statement.StatementType.IF) {
                        Statement defaultStatement = firstSwitch.getDefaultEdge().getDestination();
                        if (defaultStatement == statement) continue;
                        return null;
                    }
                    IfStatement ifStatement = (IfStatement)statement;
                    String caseLabelValue = this.findRealCaseValue(ifStatement, firstSwitchSelectorQualifier);
                    if (caseLabelValue == null) {
                        return null;
                    }
                    if (!realCaseValueHashCodes.remove(caseLabelValue.hashCode())) {
                        return null;
                    }
                    if (ifStatement.getIfstat() == null) {
                        return null;
                    }
                    List<Exprent> ifStatementExprents = ifStatement.getIfstat().getExprents();
                    if (ifStatementExprents.size() != 1) {
                        return null;
                    }
                    if (ifStatementExprents.get((int)0).type != 2) {
                        return null;
                    }
                    AssignmentExprent assignment = (AssignmentExprent)ifStatementExprents.get(0);
                    if (assignment.getLeft().type != 12 || assignment.getRight().type != 3) {
                        return null;
                    }
                    if (tmpVarAssignTo != null && !tmpVarAssignTo.equals(assignment.getLeft())) {
                        return null;
                    }
                    tmpVarAssignTo = (VarExprent)assignment.getLeft();
                    Object valueAssignedToTmpVar = ((ConstExprent)assignment.getRight()).getValue();
                    if (!(valueAssignedToTmpVar instanceof Integer)) {
                        return null;
                    }
                    mappedCaseLabelValues.put((Integer)valueAssignedToTmpVar, caseLabelValue);
                    if (ifStatement.getLabelEdges().size() != 1) {
                        return null;
                    }
                    Statement edgeDestination = ifStatement.getLabelEdges().iterator().next().getDestination();
                    if (edgeDestination.type == Statement.StatementType.SEQUENCE) {
                        edgeDestination = edgeDestination.getFirst();
                    }
                    if (edgeDestination.type != Statement.StatementType.SWITCH) {
                        return null;
                    }
                    if (secondSwitch != null && secondSwitch != edgeDestination) {
                        return null;
                    }
                    secondSwitch = (SwitchStatement)edgeDestination;
                }
                if (secondSwitch == null || !realCaseValueHashCodes.isEmpty()) {
                    return null;
                }
                Exprent siblingSwitchExprent = secondSwitch.getHeadExprent();
                if (siblingSwitchExprent == null) {
                    return null;
                }
                if (siblingSwitchExprent.type != 11) {
                    return null;
                }
                if (!tmpVarAssignTo.equals(((SwitchExprent)siblingSwitchExprent).getValue())) {
                    return null;
                }
                return new SwitchOnStringCandidate.JavacSwitchCandidate(firstSwitch, firstSwitchSelectorQualifier, tmpVarAssignTo, secondSwitch, mappedCaseLabelValues);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "firstSwitch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "switchSelector";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchRecognizer$JavacRecognizer";
                objectArray[2] = "recognize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static abstract class SwitchOnStringCandidate {
        private SwitchOnStringCandidate() {
        }

        abstract void simplify(Map<VarExprent, Statement> var1);

        @Nullable
        private static AssignmentExprent addTempVarAssignment(@NotNull Exprent exprent, @NotNull VarExprent varExprent, @NotNull Statement statement, @NotNull Map<VarExprent, Statement> tempVarAssignments) {
            if (exprent == null) {
                SwitchOnStringCandidate.$$$reportNull$$$0(0);
            }
            if (varExprent == null) {
                SwitchOnStringCandidate.$$$reportNull$$$0(1);
            }
            if (statement == null) {
                SwitchOnStringCandidate.$$$reportNull$$$0(2);
            }
            if (tempVarAssignments == null) {
                SwitchOnStringCandidate.$$$reportNull$$$0(3);
            }
            if (exprent.type != 2) {
                return null;
            }
            AssignmentExprent assignment = (AssignmentExprent)exprent;
            if (!varExprent.isDefinition() && varExprent.equals(assignment.getLeft())) {
                tempVarAssignments.put(varExprent, statement);
                return assignment;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "varExprent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tempVarAssignments";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchOnStringCandidate";
            objectArray[2] = "addTempVarAssignment";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class EcjSwitchCandidate
        extends SwitchOnStringCandidate {
            @NotNull
            private final SwitchStatement switchStatement;
            @NotNull
            private final Exprent switchSelector;
            @NotNull
            private final VarExprent tmpVar;
            @NotNull
            private final @NotNull Map<Integer, @NotNull IfStatement> mappedIfStatements;
            @NotNull
            private final @NotNull Map<Integer, @NotNull String> mappedCaseLabelValues;

            private EcjSwitchCandidate(@NotNull SwitchStatement switchStatement, @NotNull Exprent switchSelector, @NotNull VarExprent tmpVar, @NotNull Map<Integer, IfStatement> mappedIfStatements, @NotNull Map<Integer, String> mappedCaseLabelValues) {
                if (switchStatement == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(0);
                }
                if (switchSelector == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(1);
                }
                if (tmpVar == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(2);
                }
                if (mappedIfStatements == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(3);
                }
                if (mappedCaseLabelValues == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(4);
                }
                this.switchStatement = switchStatement;
                this.switchSelector = switchSelector;
                this.tmpVar = tmpVar;
                this.mappedIfStatements = mappedIfStatements;
                this.mappedCaseLabelValues = mappedCaseLabelValues;
            }

            @Override
            void simplify(@NotNull Map<VarExprent, Statement> tempVarAssignments) {
                Exprent switchSelector;
                if (tempVarAssignments == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(5);
                }
                if ((switchSelector = this.switchStatement.getHeadExprent()) == null || switchSelector.type != 11) {
                    return;
                }
                tempVarAssignments.put(this.tmpVar, this.switchStatement);
                for (List<Exprent> values : this.switchStatement.getCaseValues()) {
                    for (int i = 0; i < values.size(); ++i) {
                        ConstExprent constExprent = (ConstExprent)values.get(i);
                        if (constExprent == null) continue;
                        int caseLabelHash = constExprent.getIntValue();
                        String labelValue = this.mappedCaseLabelValues.get(caseLabelHash);
                        values.set(i, new ConstExprent(VarType.VARTYPE_STRING, labelValue, null));
                        IfStatement ifStatement = this.mappedIfStatements.get(caseLabelHash);
                        assert (ifStatement.getStats().size() > 0);
                        if (ifStatement.getStats().size() == 1) {
                            ifStatement.getParent().replaceStatement(ifStatement, (Statement)ifStatement.getStats().get(0));
                            continue;
                        }
                        EcjSwitchCandidate.removeOuterBreakEdge(ifStatement);
                        ifStatement.getParent().replaceStatement(ifStatement, new SequenceStatement(ifStatement.getStats()));
                    }
                }
                switchSelector.replaceExprent(((SwitchExprent)switchSelector).getValue(), this.switchSelector);
            }

            private static void removeOuterBreakEdge(@NotNull IfStatement ifStatement) {
                List<StatEdge> ifStatementBreakEdges;
                if (ifStatement == null) {
                    EcjSwitchCandidate.$$$reportNull$$$0(6);
                }
                if ((ifStatementBreakEdges = ifStatement.getSuccessorEdges(StatEdge.EdgeType.BREAK)).size() != 1) {
                    return;
                }
                Statement lastStatement = (Statement)ifStatement.getStats().get(ifStatement.getStats().size() - 1);
                List<StatEdge> lastStatementBreakEdges = lastStatement.getSuccessorEdges(StatEdge.EdgeType.BREAK);
                if (lastStatementBreakEdges.size() != 1) {
                    return;
                }
                StatEdge firstIfStatementBreakEdge = ifStatementBreakEdges.get(0);
                StatEdge lastStatementBreakEdge = lastStatementBreakEdges.get(0);
                if (firstIfStatementBreakEdge.getDestination() != lastStatementBreakEdge.getDestination()) {
                    ifStatement.removeSuccessor(firstIfStatementBreakEdge);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchSelector";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tmpVar";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mappedIfStatements";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mappedCaseLabelValues";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tempVarAssignments";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchOnStringCandidate$EcjSwitchCandidate";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "simplify";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeOuterBreakEdge";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class JavacSwitchCandidate
        extends SwitchOnStringCandidate {
            @NotNull
            private final SwitchStatement firstSwitch;
            @NotNull
            private final VarExprent firstSwitchSelector;
            @NotNull
            private final VarExprent tmpVarInFirstSwitch;
            @NotNull
            private final SwitchStatement secondSwitch;
            @NotNull
            private final @NotNull Map<Integer, @NotNull String> mappedCaseLabelValues;

            JavacSwitchCandidate(@NotNull SwitchStatement firstSwitch, @NotNull VarExprent firstSwitchSelector, @NotNull VarExprent tmpVarInFirstSwitch, @NotNull SwitchStatement secondSwitch, @NotNull Map<Integer, String> mappedCaseLabelValues) {
                if (firstSwitch == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(0);
                }
                if (firstSwitchSelector == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(1);
                }
                if (tmpVarInFirstSwitch == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(2);
                }
                if (secondSwitch == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(3);
                }
                if (mappedCaseLabelValues == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(4);
                }
                this.firstSwitch = firstSwitch;
                this.secondSwitch = secondSwitch;
                this.firstSwitchSelector = firstSwitchSelector;
                this.tmpVarInFirstSwitch = tmpVarInFirstSwitch;
                this.mappedCaseLabelValues = mappedCaseLabelValues;
            }

            @Override
            void simplify(@NotNull Map<VarExprent, Statement> tempVarAssignments) {
                boolean parentsAreTheSame;
                AssignmentExprent assignment;
                AssignmentExprent assignment2;
                Exprent secondSwitchSelector;
                if (tempVarAssignments == null) {
                    JavacSwitchCandidate.$$$reportNull$$$0(5);
                }
                if ((secondSwitchSelector = this.secondSwitch.getHeadExprent()) == null || secondSwitchSelector.type != 11) {
                    return;
                }
                Statement firstStatementInFirstSwitch = this.firstSwitch.getFirst();
                if (firstStatementInFirstSwitch.type != Statement.StatementType.BASIC_BLOCK) {
                    return;
                }
                Statement firstStatementInSecondSwitch = this.secondSwitch.getFirst();
                if (firstStatementInSecondSwitch.type != Statement.StatementType.BASIC_BLOCK) {
                    return;
                }
                for (List<Exprent> values : this.secondSwitch.getCaseValues()) {
                    for (int i = 0; i < values.size(); ++i) {
                        ConstExprent constExprent = (ConstExprent)values.get(i);
                        if (constExprent == null) continue;
                        String labelValue = this.mappedCaseLabelValues.get(constExprent.getIntValue());
                        values.set(i, new ConstExprent(VarType.VARTYPE_STRING, labelValue, null));
                    }
                }
                List<Exprent> firstSwitchExprents = firstStatementInFirstSwitch.getExprents();
                int lastExprentIndex = firstSwitchExprents.size();
                if (lastExprentIndex > 0 && (assignment2 = SwitchOnStringCandidate.addTempVarAssignment(firstSwitchExprents.get(lastExprentIndex - 1), this.tmpVarInFirstSwitch, this.secondSwitch, tempVarAssignments)) != null) {
                    --lastExprentIndex;
                }
                Exprent newSelector = this.firstSwitchSelector;
                if (lastExprentIndex > 0 && (assignment = SwitchOnStringCandidate.addTempVarAssignment(firstSwitchExprents.get(lastExprentIndex - 1), this.firstSwitchSelector, this.secondSwitch, tempVarAssignments)) != null) {
                    --lastExprentIndex;
                    newSelector = assignment.getRight();
                }
                List<Object> newExprents = lastExprentIndex > 0 ? List.copyOf(firstSwitchExprents.subList(0, lastExprentIndex)) : Collections.emptyList();
                Statement firstSwitchParent = this.firstSwitch.getParent();
                Statement secondSwitchParent = this.secondSwitch.getParent();
                boolean bl = parentsAreTheSame = firstSwitchParent == secondSwitchParent;
                if (parentsAreTheSame || secondSwitchParent == this.firstSwitch) {
                    firstSwitchParent.replaceStatement(this.firstSwitch, this.secondSwitch);
                } else if (secondSwitchParent.getParent() == this.firstSwitch) {
                    firstSwitchParent.replaceStatement(this.firstSwitch, secondSwitchParent);
                }
                if (parentsAreTheSame) {
                    firstSwitchParent.getStats().removeWithKey(this.secondSwitch.id);
                }
                firstStatementInSecondSwitch.getExprents().addAll(0, newExprents);
                secondSwitchSelector.replaceExprent(((SwitchExprent)secondSwitchSelector).getValue(), newSelector);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "firstSwitch";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "firstSwitchSelector";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tmpVarInFirstSwitch";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "secondSwitch";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mappedCaseLabelValues";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tempVarAssignments";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/SwitchHelper$SwitchOnStringCandidate$JavacSwitchCandidate";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "simplify";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

