/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class GeneralStatement
extends Statement {
    private GeneralStatement() {
        super(Statement.StatementType.GENERAL);
    }

    public GeneralStatement(Statement head, Collection<? extends Statement> statements, Statement post) {
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        HashSet<? extends Statement> set = new HashSet<Statement>(statements);
        set.remove(head);
        for (Statement statement : set) {
            this.stats.addWithKey(statement, statement.id);
        }
        this.post = post;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(Integer.toString(this.id)).append(":").appendLineSeparator();
        }
        buf.appendIndent(indent).append("abstract statement {").appendLineSeparator();
        for (Statement stat : this.stats) {
            buf.append(stat.toJava(indent + 1, tracer));
        }
        buf.appendIndent(indent).append("}");
        return buf;
    }
}

