/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicReference;

public class CoverageNotifications
implements CoverageSuiteListener,
Disposable {
    private final AtomicReference<Notification> myProjectOutOfDateNotification = new AtomicReference();

    public static CoverageNotifications getInstance(Project project) {
        return (CoverageNotifications)project.getService(CoverageNotifications.class);
    }

    public CoverageNotifications(Project project) {
        CoverageDataManager.getInstance((Project)project).addSuiteListener((CoverageSuiteListener)this, (Disposable)this);
    }

    public void beforeSuiteChosen() {
        this.replaceAndExpireNotification(null);
    }

    public void addNotification(Notification newNotification) {
        this.replaceAndExpireNotification(newNotification);
    }

    private void replaceAndExpireNotification(Notification newNotification) {
        Notification notification = this.myProjectOutOfDateNotification.getAndSet(newNotification);
        if (notification != null) {
            notification.expire();
            notification.hideBalloon();
        }
    }

    public void afterSuiteChosen() {
    }

    public void dispose() {
    }
}

